/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Serializable;
import java.util.ArrayList;

public class Explanation
implements Serializable {
    private float value;
    private String description;
    private ArrayList details;

    public Explanation() {
    }

    public Explanation(float value, String description) {
        this.value = value;
        this.description = description;
    }

    public boolean isMatch() {
        return 0.0f < this.getValue();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected String getSummary() {
        return String.valueOf(this.getValue()) + " = " + this.getDescription();
    }

    public Explanation[] getDetails() {
        if (this.details == null) {
            return null;
        }
        return this.details.toArray(new Explanation[0]);
    }

    public void addDetail(Explanation detail) {
        if (this.details == null) {
            this.details = new ArrayList();
        }
        this.details.add(detail);
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int depth) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < depth) {
            buffer.append("  ");
            ++i;
        }
        buffer.append(this.getSummary());
        buffer.append("\n");
        Explanation[] details = this.getDetails();
        if (details != null) {
            int i2 = 0;
            while (i2 < details.length) {
                buffer.append(details[i2].toString(depth + 1));
                ++i2;
            }
        }
        return buffer.toString();
    }

    public String toHtml() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<ul>\n");
        buffer.append("<li>");
        buffer.append(this.getSummary());
        buffer.append("<br />\n");
        Explanation[] details = this.getDetails();
        if (details != null) {
            int i = 0;
            while (i < details.length) {
                buffer.append(details[i].toHtml());
                ++i;
            }
        }
        buffer.append("</li>\n");
        buffer.append("</ul>\n");
        return buffer.toString();
    }
}

