/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class ConjunctionScorer
extends Scorer {
    private Scorer[] scorers = new Scorer[2];
    private int length = 0;
    private int first = 0;
    private int last = -1;
    private boolean firstTime = true;
    private boolean more = true;
    private float coord;

    public ConjunctionScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer) {
        if (this.length >= this.scorers.length) {
            Scorer[] temps = new Scorer[this.scorers.length * 2];
            System.arraycopy(this.scorers, 0, temps, 0, this.length);
            this.scorers = temps;
        }
        ++this.last;
        ++this.length;
        this.scorers[this.last] = scorer;
    }

    public int doc() {
        return this.scorers[this.first].doc();
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.init(true);
        } else if (this.more) {
            this.more = this.scorers[this.last].next();
        }
        return this.doNext();
    }

    private boolean doNext() throws IOException {
        while (this.more && this.scorers[this.first].doc() < this.scorers[this.last].doc()) {
            this.more = this.scorers[this.first].skipTo(this.scorers[this.last].doc());
            this.last = this.first;
            int n = this.first = this.first == this.length - 1 ? 0 : this.first + 1;
        }
        return this.more;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.init(false);
        }
        int i = 0;
        int pos = this.first;
        while (i < this.length) {
            if (!this.more) break;
            this.more = this.scorers[pos].skipTo(target);
            pos = pos == this.length - 1 ? 0 : pos + 1;
            ++i;
        }
        if (this.more) {
            this.sortScorers();
        }
        return this.doNext();
    }

    public float score() throws IOException {
        float sum = 0.0f;
        int i = 0;
        while (i < this.length) {
            sum += this.scorers[i].score();
            ++i;
        }
        return sum * this.coord;
    }

    private void init(boolean initScorers) throws IOException {
        this.coord = this.getSimilarity().coord(this.length, this.length);
        boolean bl = this.more = this.length > 0;
        if (initScorers) {
            int i = 0;
            int pos = this.first;
            while (i < this.length) {
                if (!this.more) break;
                this.more = this.scorers[pos].next();
                pos = pos == this.length - 1 ? 0 : pos + 1;
                ++i;
            }
            if (this.more) {
                this.sortScorers();
            }
        }
        this.firstTime = false;
    }

    private void sortScorers() {
        if (this.length != this.scorers.length) {
            Scorer[] temps = new Scorer[this.length];
            System.arraycopy(this.scorers, 0, temps, 0, this.length);
            this.scorers = temps;
        }
        Arrays.sort(this.scorers, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Scorer)o1).doc() - ((Scorer)o2).doc();
            }
        });
        this.first = 0;
        this.last = this.length - 1;
    }

    public Explanation explain(int doc) {
        throw new UnsupportedOperationException();
    }
}

