/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.StringHelper;

final class TermVectorsWriter {
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 1;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 2;
    static final int FORMAT_VERSION = 2;
    static final int FORMAT_SIZE = 4;
    static final String TVX_EXTENSION = ".tvx";
    static final String TVD_EXTENSION = ".tvd";
    static final String TVF_EXTENSION = ".tvf";
    private IndexOutput tvx = null;
    private IndexOutput tvd = null;
    private IndexOutput tvf = null;
    private Vector fields = null;
    private Vector terms = null;
    private FieldInfos fieldInfos;
    private TVField currentField = null;
    private long currentDocPointer = -1L;

    public TermVectorsWriter(Directory directory, String segment, FieldInfos fieldInfos) throws IOException {
        this.tvx = directory.createOutput(String.valueOf(segment) + TVX_EXTENSION);
        this.tvx.writeInt(2);
        this.tvd = directory.createOutput(String.valueOf(segment) + TVD_EXTENSION);
        this.tvd.writeInt(2);
        this.tvf = directory.createOutput(String.valueOf(segment) + TVF_EXTENSION);
        this.tvf.writeInt(2);
        this.fieldInfos = fieldInfos;
        this.fields = new Vector(fieldInfos.size());
        this.terms = new Vector();
    }

    public final void openDocument() throws IOException {
        this.closeDocument();
        this.currentDocPointer = this.tvd.getFilePointer();
    }

    public final void closeDocument() throws IOException {
        if (this.isDocumentOpen()) {
            this.closeField();
            this.writeDoc();
            this.fields.clear();
            this.currentDocPointer = -1L;
        }
    }

    public final boolean isDocumentOpen() {
        return this.currentDocPointer != -1L;
    }

    public final void openField(String field) throws IOException {
        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
        this.openField(fieldInfo.number, fieldInfo.storePositionWithTermVector, fieldInfo.storeOffsetWithTermVector);
    }

    private void openField(int fieldNumber, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot open field when no document is open.");
        }
        this.closeField();
        this.currentField = new TVField(fieldNumber, storePositionWithTermVector, storeOffsetWithTermVector);
    }

    public final void closeField() throws IOException {
        if (this.isFieldOpen()) {
            this.writeField();
            this.fields.add(this.currentField);
            this.terms.clear();
            this.currentField = null;
        }
    }

    public final boolean isFieldOpen() {
        return this.currentField != null;
    }

    public final void addTerm(String termText, int freq) {
        this.addTerm(termText, freq, null, null);
    }

    public final void addTerm(String termText, int freq, int[] positions, TermVectorOffsetInfo[] offsets) {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add terms when document is not open");
        }
        if (!this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add terms when field is not open");
        }
        this.addTermInternal(termText, freq, positions, offsets);
    }

    private final void addTermInternal(String termText, int freq, int[] positions, TermVectorOffsetInfo[] offsets) {
        TVTerm term = new TVTerm();
        term.termText = termText;
        term.freq = freq;
        term.positions = positions;
        term.offsets = offsets;
        this.terms.add(term);
    }

    /*
     * Unable to fully structure code
     */
    public final void addAllDocVectors(TermFreqVector[] vectors) throws IOException {
        this.openDocument();
        if (vectors != null) {
            i = 0;
            while (i < vectors.length) {
                block8: {
                    storePositionWithTermVector = false;
                    storeOffsetWithTermVector = false;
                    try {
                        tpVector = (TermPositionVector)vectors[i];
                        if (tpVector.size() > 0 && tpVector.getTermPositions(0) != null) {
                            storePositionWithTermVector = true;
                        }
                        if (tpVector.size() > 0 && tpVector.getOffsets(0) != null) {
                            storeOffsetWithTermVector = true;
                        }
                        fieldInfo = this.fieldInfos.fieldInfo(tpVector.getField());
                        this.openField(fieldInfo.number, storePositionWithTermVector, storeOffsetWithTermVector);
                        j = 0;
                        while (j < tpVector.size()) {
                            this.addTermInternal(tpVector.getTerms()[j], tpVector.getTermFrequencies()[j], tpVector.getTermPositions(j), tpVector.getOffsets(j));
                            ++j;
                        }
                        this.closeField();
                        break block8;
                    }
                    catch (ClassCastException ignore) {
                        tfVector = vectors[i];
                        fieldInfo = this.fieldInfos.fieldInfo(tfVector.getField());
                        this.openField(fieldInfo.number, storePositionWithTermVector, storeOffsetWithTermVector);
                        j = 0;
                        ** while (j < tfVector.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.addTermInternal(tfVector.getTerms()[j], tfVector.getTermFrequencies()[j], null, null);
                        ++j;
                        continue;
                    }
lbl31:
                    // 1 sources

                    this.closeField();
                }
                ++i;
            }
        }
        this.closeDocument();
    }

    final void close() throws IOException {
        try {
            this.closeDocument();
        }
        finally {
            IOException keep;
            block22: {
                block21: {
                    block20: {
                        keep = null;
                        if (this.tvx != null) {
                            try {
                                this.tvx.close();
                            }
                            catch (IOException e) {
                                if (keep != null) break block20;
                                keep = e;
                            }
                        }
                    }
                    if (this.tvd != null) {
                        try {
                            this.tvd.close();
                        }
                        catch (IOException e) {
                            if (keep != null) break block21;
                            keep = e;
                        }
                    }
                }
                if (this.tvf != null) {
                    try {
                        this.tvf.close();
                    }
                    catch (IOException e) {
                        if (keep != null) break block22;
                        keep = e;
                    }
                }
            }
            if (keep != null) {
                throw (IOException)keep.fillInStackTrace();
            }
        }
    }

    private void writeField() throws IOException {
        this.currentField.tvfPointer = this.tvf.getFilePointer();
        int size = this.terms.size();
        this.tvf.writeVInt(size);
        boolean storePositions = this.currentField.storePositions;
        boolean storeOffsets = this.currentField.storeOffsets;
        byte bits = 0;
        if (storePositions) {
            bits = (byte)(bits | 1);
        }
        if (storeOffsets) {
            bits = (byte)(bits | 2);
        }
        this.tvf.writeByte(bits);
        String lastTermText = "";
        int i = 0;
        while (i < size) {
            int j;
            int position;
            TVTerm term = (TVTerm)this.terms.elementAt(i);
            int start = StringHelper.stringDifference(lastTermText, term.termText);
            int length = term.termText.length() - start;
            this.tvf.writeVInt(start);
            this.tvf.writeVInt(length);
            this.tvf.writeChars(term.termText, start, length);
            this.tvf.writeVInt(term.freq);
            lastTermText = term.termText;
            if (storePositions) {
                if (term.positions == null) {
                    throw new IllegalStateException("Trying to write positions that are null!");
                }
                position = 0;
                j = 0;
                while (j < term.freq) {
                    this.tvf.writeVInt(term.positions[j] - position);
                    position = term.positions[j];
                    ++j;
                }
            }
            if (storeOffsets) {
                if (term.offsets == null) {
                    throw new IllegalStateException("Trying to write offsets that are null!");
                }
                position = 0;
                j = 0;
                while (j < term.freq) {
                    this.tvf.writeVInt(term.offsets[j].getStartOffset() - position);
                    this.tvf.writeVInt(term.offsets[j].getEndOffset() - term.offsets[j].getStartOffset());
                    position = term.offsets[j].getEndOffset();
                    ++j;
                }
            }
            ++i;
        }
    }

    private void writeDoc() throws IOException {
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Field is still open while writing document");
        }
        this.tvx.writeLong(this.currentDocPointer);
        int size = this.fields.size();
        this.tvd.writeVInt(size);
        int i = 0;
        while (i < size) {
            TVField field = (TVField)this.fields.elementAt(i);
            this.tvd.writeVInt(field.number);
            ++i;
        }
        long lastFieldPointer = 0L;
        int i2 = 0;
        while (i2 < size) {
            TVField field = (TVField)this.fields.elementAt(i2);
            this.tvd.writeVLong(field.tvfPointer - lastFieldPointer);
            lastFieldPointer = field.tvfPointer;
            ++i2;
        }
    }

    private static class TVField {
        int number;
        long tvfPointer = 0L;
        boolean storePositions = false;
        boolean storeOffsets = false;

        TVField(int number, boolean storePos, boolean storeOff) {
            this.number = number;
            this.storePositions = storePos;
            this.storeOffsets = storeOff;
        }
    }

    private static class TVTerm {
        String termText;
        int freq = 0;
        int[] positions = null;
        TermVectorOffsetInfo[] offsets = null;

        private TVTerm() {
        }
    }
}

