/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;

public class IndexWriter {
    public static long WRITE_LOCK_TIMEOUT = 1000L;
    private long writeLockTimeout = WRITE_LOCK_TIMEOUT;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = 10;
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = 1000;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    private static final int MERGE_READ_BUFFER_SIZE = 4096;
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private boolean commitPending;
    private SegmentInfos rollbackSegmentInfos;
    private SegmentInfos localRollbackSegmentInfos;
    private boolean localAutoCommit;
    private boolean autoCommit = true;
    SegmentInfos segmentInfos = new SegmentInfos();
    SegmentInfos ramSegmentInfos = new SegmentInfos();
    private final RAMDirectory ramDirectory = new RAMDirectory();
    private IndexFileDeleter deleter;
    private Lock writeLock;
    private int termIndexInterval = 128;
    private int maxBufferedDeleteTerms = 1000;
    private HashMap bufferedDeleteTerms = new HashMap();
    private int numBufferedDeleteTerms = 0;
    private boolean useCompoundFile = true;
    private boolean closeDir;
    private boolean closed;
    private int maxFieldLength = 10000;
    private int mergeFactor = 10;
    private int minMergeDocs = 10;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private PrintStream infoStream = null;
    private static PrintStream defaultInfoStream = null;

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    public boolean getUseCompoundFile() {
        this.ensureOpen();
        return this.useCompoundFile;
    }

    public void setUseCompoundFile(boolean value) {
        this.ensureOpen();
        this.useCompoundFile = value;
    }

    public void setSimilarity(Similarity similarity) {
        this.ensureOpen();
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        this.ensureOpen();
        return this.similarity;
    }

    public void setTermIndexInterval(int interval) {
        this.ensureOpen();
        this.termIndexInterval = interval;
    }

    public int getTermIndexInterval() {
        this.ensureOpen();
        return this.termIndexInterval;
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, true);
    }

    public IndexWriter(String path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true);
    }

    public IndexWriter(File path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true);
    }

    public IndexWriter(Directory d, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, true);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, autoCommit);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, autoCommit);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, deletionPolicy, autoCommit);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, deletionPolicy, autoCommit);
    }

    private void init(Directory d, Analyzer a, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit) throws CorruptIndexException, LockObtainFailedException, IOException {
        if (IndexReader.indexExists(d)) {
            this.init(d, a, false, closeDir, deletionPolicy, autoCommit);
        } else {
            this.init(d, a, true, closeDir, deletionPolicy, autoCommit);
        }
    }

    private void init(Directory d, Analyzer a, boolean create, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit) throws CorruptIndexException, LockObtainFailedException, IOException {
        Lock writeLock;
        this.closeDir = closeDir;
        this.directory = d;
        this.analyzer = a;
        this.infoStream = defaultInfoStream;
        if (create) {
            this.directory.clearLock(WRITE_LOCK_NAME);
        }
        if (!(writeLock = this.directory.makeLock(WRITE_LOCK_NAME)).obtain(this.writeLockTimeout)) {
            throw new LockObtainFailedException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        try {
            if (create) {
                try {
                    this.segmentInfos.read(this.directory);
                    this.segmentInfos.clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.segmentInfos.write(this.directory);
            } else {
                this.segmentInfos.read(this.directory);
            }
            this.autoCommit = autoCommit;
            if (!autoCommit) {
                this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
            }
            this.deleter = new IndexFileDeleter(this.directory, deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : deletionPolicy, this.segmentInfos, this.infoStream);
        }
        catch (IOException e) {
            this.writeLock.release();
            this.writeLock = null;
            throw e;
        }
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.ensureOpen();
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        this.ensureOpen();
        return this.maxMergeDocs;
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.ensureOpen();
        this.maxFieldLength = maxFieldLength;
    }

    public int getMaxFieldLength() {
        this.ensureOpen();
        return this.maxFieldLength;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.ensureOpen();
        if (maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2");
        }
        this.minMergeDocs = maxBufferedDocs;
    }

    public int getMaxBufferedDocs() {
        this.ensureOpen();
        return this.minMergeDocs;
    }

    public void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.ensureOpen();
        if (maxBufferedDeleteTerms < 1) {
            throw new IllegalArgumentException("maxBufferedDeleteTerms must at least be 1");
        }
        this.maxBufferedDeleteTerms = maxBufferedDeleteTerms;
    }

    public int getMaxBufferedDeleteTerms() {
        this.ensureOpen();
        return this.maxBufferedDeleteTerms;
    }

    public void setMergeFactor(int mergeFactor) {
        this.ensureOpen();
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        this.ensureOpen();
        return this.mergeFactor;
    }

    public static void setDefaultInfoStream(PrintStream infoStream) {
        defaultInfoStream = infoStream;
    }

    public static PrintStream getDefaultInfoStream() {
        return defaultInfoStream;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.ensureOpen();
        this.infoStream = infoStream;
        this.deleter.setInfoStream(infoStream);
    }

    public PrintStream getInfoStream() {
        this.ensureOpen();
        return this.infoStream;
    }

    public void setWriteLockTimeout(long writeLockTimeout) {
        this.ensureOpen();
        this.writeLockTimeout = writeLockTimeout;
    }

    public long getWriteLockTimeout() {
        this.ensureOpen();
        return this.writeLockTimeout;
    }

    public static void setDefaultWriteLockTimeout(long writeLockTimeout) {
        WRITE_LOCK_TIMEOUT = writeLockTimeout;
    }

    public static long getDefaultWriteLockTimeout() {
        return WRITE_LOCK_TIMEOUT;
    }

    public synchronized void close() throws CorruptIndexException, IOException {
        if (!this.closed) {
            this.flushRamSegments();
            if (this.commitPending) {
                this.segmentInfos.write(this.directory);
                this.deleter.checkpoint(this.segmentInfos, true);
                this.commitPending = false;
                this.rollbackSegmentInfos = null;
            }
            this.ramDirectory.close();
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
            this.closed = true;
            if (this.closeDir) {
                this.directory.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public Directory getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int docCount() {
        this.ensureOpen();
        int count = this.ramSegmentInfos.size();
        int i = 0;
        while (i < this.segmentInfos.size()) {
            SegmentInfo si = this.segmentInfos.info(i);
            count += si.docCount;
            ++i;
        }
        return count;
    }

    public void addDocument(Document doc) throws CorruptIndexException, IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        SegmentInfo newSegmentInfo = this.buildSingleDocSegment(doc, analyzer);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ramSegmentInfos.addElement(newSegmentInfo);
            this.maybeFlushRamSegments();
        }
    }

    SegmentInfo buildSingleDocSegment(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        DocumentWriter dw = new DocumentWriter(this.ramDirectory, analyzer, this);
        dw.setInfoStream(this.infoStream);
        String segmentName = this.newRamSegmentName();
        dw.addDocument(segmentName, doc);
        SegmentInfo si = new SegmentInfo(segmentName, 1, this.ramDirectory, false, false);
        si.setNumFields(dw.getNumFields());
        return si;
    }

    public synchronized void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.bufferDeleteTerm(term);
        this.maybeFlushRamSegments();
    }

    public synchronized void deleteDocuments(Term[] terms) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = 0;
        while (i < terms.length) {
            this.bufferDeleteTerm(terms[i]);
            ++i;
        }
        this.maybeFlushRamSegments();
    }

    public void updateDocument(Term term, Document doc) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.updateDocument(term, doc, this.getAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        SegmentInfo newSegmentInfo = this.buildSingleDocSegment(doc, analyzer);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.bufferDeleteTerm(term);
            this.ramSegmentInfos.addElement(newSegmentInfo);
            this.maybeFlushRamSegments();
        }
    }

    final synchronized String newRamSegmentName() {
        return "_ram_" + Integer.toString(this.ramSegmentInfos.counter++, 36);
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getRamSegmentCount() {
        return this.ramSegmentInfos.size();
    }

    final synchronized int getDocCount(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).docCount;
        }
        return -1;
    }

    final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public synchronized void optimize() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || SegmentReader.hasSeparateNorms(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory || this.useCompoundFile && !SegmentReader.usesCompoundFile(this.segmentInfos.info(0)))) {
            int minSegment = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(this.segmentInfos, minSegment < 0 ? 0 : minSegment, this.segmentInfos.size());
        }
    }

    private void startTransaction() throws IOException {
        this.localRollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        this.localAutoCommit = this.autoCommit;
        if (this.localAutoCommit) {
            this.flushRamSegments();
            this.autoCommit = false;
        } else {
            this.deleter.incRef(this.segmentInfos, false);
        }
    }

    private void rollbackTransaction() throws IOException {
        this.autoCommit = this.localAutoCommit;
        this.segmentInfos.clear();
        this.segmentInfos.addAll(this.localRollbackSegmentInfos);
        this.localRollbackSegmentInfos = null;
        this.deleter.checkpoint(this.segmentInfos, false);
        if (!this.autoCommit) {
            this.deleter.decRef(this.segmentInfos);
        }
        this.deleter.refresh();
    }

    private void commitTransaction() throws IOException {
        this.autoCommit = this.localAutoCommit;
        boolean success = false;
        try {
            this.checkpoint();
            success = true;
        }
        finally {
            if (!success) {
                this.rollbackTransaction();
            }
        }
        if (!this.autoCommit) {
            this.deleter.decRef(this.localRollbackSegmentInfos);
        }
        this.localRollbackSegmentInfos = null;
        this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
    }

    public synchronized void abort() throws IOException {
        this.ensureOpen();
        if (this.autoCommit) {
            throw new IllegalStateException("abort() can only be called when IndexWriter was opened with autoCommit=false");
        }
        this.segmentInfos.clear();
        this.segmentInfos.addAll(this.rollbackSegmentInfos);
        this.deleter.checkpoint(this.segmentInfos, false);
        this.deleter.refresh();
        this.ramSegmentInfos = new SegmentInfos();
        this.bufferedDeleteTerms.clear();
        this.numBufferedDeleteTerms = 0;
        this.commitPending = false;
        this.close();
    }

    private void checkpoint() throws IOException {
        if (this.autoCommit) {
            this.segmentInfos.write(this.directory);
        } else {
            this.commitPending = true;
        }
    }

    public synchronized void addIndexes(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.optimize();
        int start = this.segmentInfos.size();
        boolean success = false;
        this.startTransaction();
        try {
            int i = 0;
            while (i < dirs.length) {
                SegmentInfos sis = new SegmentInfos();
                sis.read(dirs[i]);
                int j = 0;
                while (j < sis.size()) {
                    this.segmentInfos.addElement(sis.info(j));
                    ++j;
                }
                ++i;
            }
            while (this.segmentInfos.size() > start + this.mergeFactor) {
                int base = start;
                while (base < this.segmentInfos.size()) {
                    int end = Math.min(this.segmentInfos.size(), base + this.mergeFactor);
                    if (end - base > 1) {
                        this.mergeSegments(this.segmentInfos, base, end);
                    }
                    ++base;
                }
            }
            success = true;
        }
        finally {
            if (success) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
        this.optimize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addIndexesNoOptimize(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.flushRamSegments();
        int startUpperBound = this.minMergeDocs;
        boolean success = false;
        this.startTransaction();
        try {
            int i = 0;
            while (i < dirs.length) {
                if (this.directory == dirs[i]) {
                    throw new IllegalArgumentException("Cannot add this index to itself");
                }
                SegmentInfos sis = new SegmentInfos();
                sis.read(dirs[i]);
                int j = 0;
                while (j < sis.size()) {
                    SegmentInfo info = sis.info(j);
                    this.segmentInfos.addElement(info);
                    while (startUpperBound < info.docCount) {
                        if ((startUpperBound *= this.mergeFactor) <= this.maxMergeDocs) continue;
                        throw new IllegalArgumentException("Upper bound cannot exceed maxMergeDocs");
                    }
                    ++j;
                }
                ++i;
            }
            this.maybeMergeSegments(startUpperBound);
            int segmentCount = this.segmentInfos.size();
            int numTailSegments = 0;
            while (numTailSegments < segmentCount && startUpperBound >= this.segmentInfos.info((int)(segmentCount - 1 - numTailSegments)).docCount) {
                ++numTailSegments;
            }
            if (numTailSegments == 0) {
                success = true;
                return;
            }
            if (this.checkNonDecreasingLevels(segmentCount - numTailSegments)) {
                int numSegmentsToCopy = 0;
                while (numSegmentsToCopy < segmentCount && this.directory != this.segmentInfos.info((int)(segmentCount - 1 - numSegmentsToCopy)).dir) {
                    ++numSegmentsToCopy;
                }
                if (numSegmentsToCopy == 0) {
                    success = true;
                    return;
                }
                int i2 = segmentCount - numSegmentsToCopy;
                while (i2 < segmentCount) {
                    this.mergeSegments(this.segmentInfos, i2, i2 + 1);
                    ++i2;
                }
                if (this.checkNonDecreasingLevels(segmentCount - numSegmentsToCopy)) {
                    success = true;
                    return;
                }
            }
            this.mergeSegments(this.segmentInfos, segmentCount - numTailSegments, segmentCount);
            if (this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).docCount > startUpperBound) {
                this.maybeMergeSegments(startUpperBound * this.mergeFactor);
            }
            success = true;
            return;
        }
        finally {
            if (success) {
                this.commitTransaction();
            } else {
                this.rollbackTransaction();
            }
        }
    }

    public synchronized void addIndexes(IndexReader[] readers) throws CorruptIndexException, IOException {
        SegmentInfo info;
        boolean success;
        this.ensureOpen();
        this.optimize();
        String mergedName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this, mergedName);
        IndexReader sReader = null;
        try {
            if (this.segmentInfos.size() == 1) {
                sReader = SegmentReader.get(this.segmentInfos.info(0));
                merger.add(sReader);
            }
            int i = 0;
            while (i < readers.length) {
                merger.add(readers[i]);
                ++i;
            }
            success = false;
            this.startTransaction();
            try {
                int docCount = merger.merge();
                if (sReader != null) {
                    sReader.close();
                    sReader = null;
                }
                this.segmentInfos.setSize(0);
                info = new SegmentInfo(mergedName, docCount, this.directory, false, true);
                this.segmentInfos.addElement(info);
                success = true;
            }
            finally {
                if (!success) {
                    this.rollbackTransaction();
                } else {
                    this.commitTransaction();
                }
            }
        }
        finally {
            if (sReader != null) {
                sReader.close();
            }
        }
        if (this.useCompoundFile) {
            success = false;
            this.startTransaction();
            try {
                merger.createCompoundFile(String.valueOf(mergedName) + ".cfs");
                info.setUseCompoundFile(true);
            }
            finally {
                if (!success) {
                    this.rollbackTransaction();
                } else {
                    this.commitTransaction();
                }
            }
        }
    }

    void doAfterFlush() throws IOException {
    }

    protected final void maybeFlushRamSegments() throws CorruptIndexException, IOException {
        if (this.ramSegmentInfos.size() >= this.minMergeDocs || this.numBufferedDeleteTerms >= this.maxBufferedDeleteTerms) {
            this.flushRamSegments();
        }
    }

    private final synchronized void flushRamSegments() throws CorruptIndexException, IOException {
        this.flushRamSegments(true);
    }

    protected final synchronized void flushRamSegments(boolean triggerMerge) throws CorruptIndexException, IOException {
        if (this.ramSegmentInfos.size() > 0 || this.bufferedDeleteTerms.size() > 0) {
            this.mergeSegments(this.ramSegmentInfos, 0, this.ramSegmentInfos.size());
            if (triggerMerge) {
                this.maybeMergeSegments(this.minMergeDocs);
            }
        }
    }

    public final synchronized void flush() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.flushRamSegments();
    }

    public final long ramSizeInBytes() {
        this.ensureOpen();
        return this.ramDirectory.sizeInBytes();
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.ramSegmentInfos.size();
    }

    private final void maybeMergeSegments(int startUpperBound) throws CorruptIndexException, IOException {
        long lowerBound = -1L;
        long upperBound = startUpperBound;
        while (upperBound < (long)this.maxMergeDocs) {
            int numSegments;
            int minSegment = this.segmentInfos.size();
            int maxSegment = -1;
            while (--minSegment >= 0) {
                SegmentInfo si = this.segmentInfos.info(minSegment);
                if (maxSegment == -1 && (long)si.docCount > lowerBound && (long)si.docCount <= upperBound) {
                    maxSegment = minSegment;
                    continue;
                }
                if ((long)si.docCount > upperBound) break;
            }
            if ((numSegments = ++maxSegment - ++minSegment) < this.mergeFactor) break;
            boolean exceedsUpperLimit = false;
            while (numSegments >= this.mergeFactor) {
                int docCount = this.mergeSegments(this.segmentInfos, minSegment, minSegment + this.mergeFactor);
                numSegments -= this.mergeFactor;
                if ((long)docCount > upperBound) {
                    ++minSegment;
                    exceedsUpperLimit = true;
                    continue;
                }
                ++numSegments;
            }
            if (!exceedsUpperLimit) break;
            lowerBound = upperBound;
            upperBound *= (long)this.mergeFactor;
        }
    }

    private final int mergeSegments(SegmentInfos sourceSegments, int minSegment, int end) throws CorruptIndexException, IOException {
        boolean doMerge = end > 0;
        String mergedName = this.newSegmentName();
        SegmentMerger merger = null;
        ArrayList<SegmentInfo> ramSegmentsToDelete = new ArrayList<SegmentInfo>();
        SegmentInfo newSegment = null;
        int mergedDocCount = 0;
        boolean anyDeletes = this.bufferedDeleteTerms.size() != 0;
        try {
            if (doMerge) {
                if (this.infoStream != null) {
                    this.infoStream.print("merging segments");
                }
                merger = new SegmentMerger(this, mergedName);
                int i = minSegment;
                while (i < end) {
                    SegmentInfo si = sourceSegments.info(i);
                    if (this.infoStream != null) {
                        this.infoStream.print(" " + si.name + " (" + si.docCount + " docs)");
                    }
                    SegmentReader reader = SegmentReader.get(si, 4096);
                    merger.add(reader);
                    if (reader.directory() == this.ramDirectory) {
                        ramSegmentsToDelete.add(si);
                    }
                    ++i;
                }
            }
            SegmentInfos rollback = null;
            boolean success = false;
            try {
                if (doMerge) {
                    mergedDocCount = merger.merge();
                    if (this.infoStream != null) {
                        this.infoStream.println(" into " + mergedName + " (" + mergedDocCount + " docs)");
                    }
                    newSegment = new SegmentInfo(mergedName, mergedDocCount, this.directory, false, true);
                }
                if (sourceSegments != this.ramSegmentInfos || anyDeletes) {
                    rollback = (SegmentInfos)this.segmentInfos.clone();
                }
                if (doMerge) {
                    if (sourceSegments == this.ramSegmentInfos) {
                        this.segmentInfos.addElement(newSegment);
                    } else {
                        int i = end - 1;
                        while (i > minSegment) {
                            sourceSegments.remove(i);
                            --i;
                        }
                        this.segmentInfos.set(minSegment, newSegment);
                    }
                }
                if (sourceSegments == this.ramSegmentInfos) {
                    this.maybeApplyDeletes(doMerge);
                    this.doAfterFlush();
                }
                this.checkpoint();
                success = true;
            }
            finally {
                if (success) {
                    if (sourceSegments == this.ramSegmentInfos) {
                        this.ramSegmentInfos.removeAllElements();
                    }
                } else {
                    if (sourceSegments == this.ramSegmentInfos && !anyDeletes) {
                        if (newSegment != null && this.segmentInfos.size() > 0 && this.segmentInfos.info(this.segmentInfos.size() - 1) == newSegment) {
                            this.segmentInfos.remove(this.segmentInfos.size() - 1);
                        }
                    } else if (rollback != null) {
                        this.segmentInfos.clear();
                        this.segmentInfos.addAll(rollback);
                    }
                    this.deleter.refresh();
                }
            }
        }
        finally {
            if (doMerge) {
                merger.closeReaders();
            }
        }
        this.deleter.deleteDirect(this.ramDirectory, ramSegmentsToDelete);
        this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
        if (this.useCompoundFile && doMerge) {
            boolean success = false;
            try {
                merger.createCompoundFile(String.valueOf(mergedName) + ".cfs");
                newSegment.setUseCompoundFile(true);
                this.checkpoint();
                success = true;
            }
            finally {
                if (!success) {
                    newSegment.setUseCompoundFile(false);
                    this.deleter.refresh();
                }
            }
            this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
        }
        return mergedDocCount;
    }

    private final void maybeApplyDeletes(boolean doMerge) throws CorruptIndexException, IOException {
        if (this.bufferedDeleteTerms.size() > 0) {
            if (this.infoStream != null) {
                this.infoStream.println("flush " + this.numBufferedDeleteTerms + " buffered deleted terms on " + this.segmentInfos.size() + " segments.");
            }
            if (doMerge) {
                IndexReader reader = null;
                try {
                    reader = SegmentReader.get(this.segmentInfos.info(this.segmentInfos.size() - 1));
                    this.applyDeletesSelectively(this.bufferedDeleteTerms, reader);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.doCommit();
                        }
                        finally {
                            reader.doClose();
                        }
                    }
                }
            }
            int infosEnd = this.segmentInfos.size();
            if (doMerge) {
                --infosEnd;
            }
            int i = 0;
            while (i < infosEnd) {
                SegmentReader reader = null;
                try {
                    reader = SegmentReader.get(this.segmentInfos.info(i));
                    this.applyDeletes(this.bufferedDeleteTerms, reader);
                }
                finally {
                    if (reader != null) {
                        try {
                            ((IndexReader)reader).doCommit();
                        }
                        finally {
                            ((IndexReader)reader).doClose();
                        }
                    }
                }
                ++i;
            }
            this.bufferedDeleteTerms.clear();
            this.numBufferedDeleteTerms = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean checkNonDecreasingLevels(int start) {
        lowerBound = -1;
        upperBound = this.minMergeDocs;
        i = this.segmentInfos.size() - 1;
        while (i >= start) {
            docCount = this.segmentInfos.info((int)i).docCount;
            if (docCount > lowerBound) ** GOTO lbl10
            return false;
lbl-1000:
            // 1 sources

            {
                lowerBound = upperBound;
                upperBound *= this.mergeFactor;
lbl10:
                // 2 sources

                ** while (docCount > upperBound)
            }
lbl11:
            // 1 sources

            --i;
        }
        return true;
    }

    final synchronized int getBufferedDeleteTermsSize() {
        return this.bufferedDeleteTerms.size();
    }

    final synchronized int getNumBufferedDeleteTerms() {
        return this.numBufferedDeleteTerms;
    }

    private void bufferDeleteTerm(Term term) {
        Num num = (Num)this.bufferedDeleteTerms.get(term);
        if (num == null) {
            this.bufferedDeleteTerms.put(term, new Num(this.ramSegmentInfos.size()));
        } else {
            num.setNum(this.ramSegmentInfos.size());
        }
        ++this.numBufferedDeleteTerms;
    }

    private final void applyDeletesSelectively(HashMap deleteTerms, IndexReader reader) throws CorruptIndexException, IOException {
        block3: for (Map.Entry entry : deleteTerms.entrySet()) {
            Term term = (Term)entry.getKey();
            TermDocs docs = reader.termDocs(term);
            if (docs == null) continue;
            int num = ((Num)entry.getValue()).getNum();
            try {
                while (docs.next()) {
                    int doc = docs.doc();
                    if (doc >= num) {
                        continue block3;
                    }
                    reader.deleteDocument(doc);
                }
            }
            finally {
                docs.close();
            }
        }
    }

    private final void applyDeletes(HashMap deleteTerms, IndexReader reader) throws CorruptIndexException, IOException {
        for (Map.Entry entry : deleteTerms.entrySet()) {
            reader.deleteDocuments((Term)entry.getKey());
        }
    }

    private static class Num {
        private int num;

        Num(int num) {
            this.num = num;
        }

        int getNum() {
            return this.num;
        }

        void setNum(int num) {
            this.num = num;
        }
    }
}

