/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

final class IndexFileNames {
    static final String SEGMENTS = "segments";
    static final String SEGMENTS_GEN = "segments.gen";
    static final String DELETABLE = "deletable";
    static final String NORMS_EXTENSION = "nrm";
    static final String COMPOUND_FILE_EXTENSION = "cfs";
    static final String DELETES_EXTENSION = "del";
    static final String PLAIN_NORMS_EXTENSION = "f";
    static final String SEPARATE_NORMS_EXTENSION = "s";
    static final String[] INDEX_EXTENSIONS = new String[]{"cfs", "fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "del", "tvx", "tvd", "tvf", "gen", "nrm"};
    static final String[] INDEX_EXTENSIONS_IN_COMPOUND_FILE = new String[]{"fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "tvx", "tvd", "tvf", "nrm"};
    static final String[] COMPOUND_EXTENSIONS = new String[]{"fnm", "frq", "prx", "fdx", "fdt", "tii", "tis"};
    static final String[] VECTOR_EXTENSIONS = new String[]{"tvx", "tvd", "tvf"};

    IndexFileNames() {
    }

    static final String fileNameFromGeneration(String base, String extension, long gen) {
        if (gen == -1L) {
            return null;
        }
        if (gen == 0L) {
            return String.valueOf(base) + extension;
        }
        return String.valueOf(base) + "_" + Long.toString(gen, 36) + extension;
    }
}

