/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public final class Document
implements Serializable {
    List fields = new Vector();
    private float boost = 1.0f;

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public final void add(Fieldable field) {
        this.fields.add(field);
    }

    public final void removeField(String name) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Fieldable field = (Fieldable)it.next();
            if (!field.name().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public final void removeFields(String name) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Fieldable field = (Fieldable)it.next();
            if (!field.name().equals(name)) continue;
            it.remove();
        }
    }

    public final Field getField(String name) {
        int i = 0;
        while (i < this.fields.size()) {
            Field field = (Field)this.fields.get(i);
            if (field.name().equals(name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public Fieldable getFieldable(String name) {
        int i = 0;
        while (i < this.fields.size()) {
            Fieldable field = (Fieldable)this.fields.get(i);
            if (field.name().equals(name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public final String get(String name) {
        int i = 0;
        while (i < this.fields.size()) {
            Fieldable field = (Fieldable)this.fields.get(i);
            if (field.name().equals(name) && !field.isBinary()) {
                return field.stringValue();
            }
            ++i;
        }
        return null;
    }

    public final Enumeration fields() {
        return ((Vector)this.fields).elements();
    }

    public final List getFields() {
        return this.fields;
    }

    public final Field[] getFields(String name) {
        ArrayList<Field> result = new ArrayList<Field>();
        int i = 0;
        while (i < this.fields.size()) {
            Field field = (Field)this.fields.get(i);
            if (field.name().equals(name)) {
                result.add(field);
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new Field[result.size()]);
    }

    public Fieldable[] getFieldables(String name) {
        ArrayList<Fieldable> result = new ArrayList<Fieldable>();
        int i = 0;
        while (i < this.fields.size()) {
            Fieldable field = (Fieldable)this.fields.get(i);
            if (field.name().equals(name)) {
                result.add(field);
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new Fieldable[result.size()]);
    }

    public final String[] getValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.fields.size()) {
            Fieldable field = (Fieldable)this.fields.get(i);
            if (field.name().equals(name) && !field.isBinary()) {
                result.add(field.stringValue());
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    public final byte[][] getBinaryValues(String name) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        int i = 0;
        while (i < this.fields.size()) {
            Fieldable field = (Fieldable)this.fields.get(i);
            if (field.name().equals(name) && field.isBinary()) {
                result.add(field.binaryValue());
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return (byte[][])result.toArray((T[])new byte[result.size()][]);
    }

    public final byte[] getBinaryValue(String name) {
        int i = 0;
        while (i < this.fields.size()) {
            Fieldable field = (Fieldable)this.fields.get(i);
            if (field.name().equals(name) && field.isBinary()) {
                return field.binaryValue();
            }
            ++i;
        }
        return null;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document<");
        int i = 0;
        while (i < this.fields.size()) {
            Fieldable field = (Fieldable)this.fields.get(i);
            buffer.append(field.toString());
            if (i != this.fields.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        buffer.append(">");
        return buffer.toString();
    }
}

