/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class StopFilter
extends TokenFilter {
    private final Set stopWords;
    private final boolean ignoreCase;

    public StopFilter(TokenStream input, String[] stopWords) {
        this(input, stopWords, false);
    }

    public StopFilter(TokenStream in, String[] stopWords, boolean ignoreCase) {
        super(in);
        this.ignoreCase = ignoreCase;
        this.stopWords = StopFilter.makeStopSet(stopWords, ignoreCase);
    }

    public StopFilter(TokenStream input, Set stopWords, boolean ignoreCase) {
        super(input);
        this.ignoreCase = ignoreCase;
        this.stopWords = stopWords;
    }

    public StopFilter(TokenStream in, Set stopWords) {
        this(in, stopWords, false);
    }

    public static final Set makeStopSet(String[] stopWords) {
        return StopFilter.makeStopSet(stopWords, false);
    }

    public static final Set makeStopSet(String[] stopWords, boolean ignoreCase) {
        HashSet<String> stopTable = new HashSet<String>(stopWords.length);
        int i = 0;
        while (i < stopWords.length) {
            stopTable.add(ignoreCase ? stopWords[i].toLowerCase() : stopWords[i]);
            ++i;
        }
        return stopTable;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            String termText;
            String string = termText = this.ignoreCase ? token.termText.toLowerCase() : token.termText;
            if (!this.stopWords.contains(termText)) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

