/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siapi;

import com.ibm.siapi.SiapiException;
import com.ibm.siapi.SiapiMessageArg;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class SiapiMessage {
    public static final int SEVERITY_ERROR = 1;
    public static final int SEVERITY_FATAL_ERROR = 2;
    public static final int SEVERITY_WARNING = 3;
    public static final int SEVERITY_INFORMATIONAL = 4;
    private int severity;
    private String messageID = null;
    private String resourceBundleName = null;
    private SiapiMessageArg[] messageArgs = null;
    private String message = null;
    private Throwable rootCause = null;
    private static final String SIAPI_RES_BUNDLE_NAME = "com.ibm.siapi.SiapiResources";
    private static final String MSG_INFO_NOT_SET_ERR = "SIAPI0100E";
    private static final String MSG_LOAD_RES_BUNDLE_ERR = "SIAPI0101E";
    private static final String MSG_GET_ENTRY_ERR = "SIAPI0102E";
    private static final String MSG_FORMAT_MSG_ERR = "SIAPI0103E";

    public SiapiMessage(int severity, String msgID, String resBundleName) {
        this.severity = severity;
        this.messageID = msgID;
        this.resourceBundleName = resBundleName;
    }

    public SiapiMessage(int severity, String msgID, String resBundleName, Throwable relatedCause) {
        this.severity = severity;
        this.messageID = msgID;
        this.resourceBundleName = resBundleName;
        this.rootCause = relatedCause;
    }

    public SiapiMessage(int severity, String msgID, String resBundleName, SiapiMessageArg[] msgArgs) {
        this.severity = severity;
        this.messageID = msgID;
        this.resourceBundleName = resBundleName;
        this.messageArgs = msgArgs;
    }

    public SiapiMessage(int severity, String msgID, String resBundleName, SiapiMessageArg[] msgArgs, Throwable relatedCause) {
        this.severity = severity;
        this.messageID = msgID;
        this.resourceBundleName = resBundleName;
        this.messageArgs = msgArgs;
        this.rootCause = relatedCause;
    }

    public SiapiMessage(int severity, String messageText) {
        this.severity = severity;
        this.message = messageText;
    }

    public SiapiMessage(int severity, String messageText, Throwable relatedCause) {
        this.severity = severity;
        this.message = messageText;
        this.rootCause = relatedCause;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public SiapiMessageArg[] getMessageArgs() {
        return this.messageArgs;
    }

    public Throwable getCause() {
        return this.rootCause;
    }

    public void setCause(Throwable relatedCause) {
        this.rootCause = relatedCause;
    }

    public String getMessage() throws SiapiException {
        return this.formatMessage(false, Locale.getDefault());
    }

    public String getMessage(boolean prefixMsgID) throws SiapiException {
        return this.formatMessage(prefixMsgID, Locale.getDefault());
    }

    public String getMessage(Locale loc) throws SiapiException {
        return this.formatMessage(false, loc);
    }

    public String getMessage(boolean prefixMsgID, Locale loc) throws SiapiException {
        return this.formatMessage(prefixMsgID, loc);
    }

    public static String[] getMessages(boolean prefixMsgID, Locale loc, List msgs) {
        if (msgs == null || msgs.size() < 1) {
            return null;
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String[] formatMsgs = new String[msgs.size()];
        int i = 0;
        while (i < formatMsgs.length) {
            SiapiMessage smsg = (SiapiMessage)msgs.get(i);
            try {
                formatMsgs[i] = smsg.getMessage(prefixMsgID, loc);
            }
            catch (SiapiException siapiEx) {
                try {
                    formatMsgs[i] = siapiEx.getMessageObject().getMessage(prefixMsgID, loc);
                }
                catch (SiapiException siapiEx2) {
                    formatMsgs[i] = smsg.toString();
                }
            }
            ++i;
        }
        return formatMsgs;
    }

    public void setMessage(String messageText) {
        this.message = messageText;
        this.messageID = null;
        this.resourceBundleName = null;
        this.messageArgs = null;
    }

    public String toString() {
        StringBuffer data = new StringBuffer();
        if (this.severity == 1) {
            data.append("SEVERITY_ERROR: ");
        } else if (this.severity == 2) {
            data.append("SEVERITY_FATAL_ERROR: ");
        } else if (this.severity == 3) {
            data.append("SEVERITY_WARNING: ");
        } else if (this.severity == 4) {
            data.append("SEVERITY_INFORMATIONAL: ");
        }
        data.append("Message ID: [");
        if (this.messageID != null) {
            data.append(this.messageID);
        }
        data.append("] Resource Bundle: [");
        if (this.resourceBundleName != null) {
            data.append(this.resourceBundleName);
        }
        data.append("] Message Text: [");
        if (this.message != null) {
            data.append(this.message);
        }
        data.append("]");
        if (this.messageArgs != null) {
            data.append(" Message Arguments:");
            int i = 0;
            while (i < this.messageArgs.length) {
                data.append(" Arg" + i + ": ");
                data.append(this.messageArgs[i].toString());
                ++i;
            }
        }
        return data.toString();
    }

    private final String formatMessage(boolean prefixMsgID, Locale loc) throws SiapiException {
        if (this.messageID == null && this.resourceBundleName == null && this.message == null) {
            throw new SiapiException(1, 23, MSG_INFO_NOT_SET_ERR, SIAPI_RES_BUNDLE_NAME);
        }
        if (this.message != null) {
            return this.message;
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(this.resourceBundleName, loc);
        }
        catch (Exception loadResEx) {
            SiapiMessageArg[] args = new SiapiMessageArg[]{new SiapiMessageArg(this.resourceBundleName), new SiapiMessageArg(loc.toString()), new SiapiMessageArg(loadResEx.toString())};
            throw new SiapiException(1, 23, MSG_LOAD_RES_BUNDLE_ERR, SIAPI_RES_BUNDLE_NAME, args, loadResEx);
        }
        String rawMessage = null;
        try {
            rawMessage = rb.getString(this.messageID);
        }
        catch (Exception getMsgEx) {
            SiapiMessageArg[] args = new SiapiMessageArg[]{new SiapiMessageArg(this.messageID), new SiapiMessageArg(this.resourceBundleName), new SiapiMessageArg(loc.toString()), new SiapiMessageArg(getMsgEx.toString())};
            throw new SiapiException(1, 23, MSG_GET_ENTRY_ERR, SIAPI_RES_BUNDLE_NAME, args, getMsgEx);
        }
        String msg = null;
        msg = prefixMsgID ? String.valueOf(this.messageID) + " " + rawMessage : rawMessage;
        if (this.messageArgs == null || this.messageArgs.length == 0) {
            return msg;
        }
        try {
            Object[] args = new Object[this.messageArgs.length];
            int i = 0;
            while (i < args.length) {
                args[i] = this.messageArgs[i].getObject();
                ++i;
            }
            MessageFormat msgForm = new MessageFormat(msg);
            msgForm.setLocale(loc);
            StringBuffer formMsg = new StringBuffer();
            FieldPosition ignore = new FieldPosition(0);
            msgForm.format(args, formMsg, ignore);
            return formMsg.toString();
        }
        catch (Exception formMsgEx) {
            SiapiMessageArg[] args = new SiapiMessageArg[]{new SiapiMessageArg(this.messageID), new SiapiMessageArg(this.resourceBundleName), new SiapiMessageArg(loc.toString()), new SiapiMessageArg(formMsgEx.toString())};
            throw new SiapiException(1, 23, MSG_FORMAT_MSG_ERR, SIAPI_RES_BUNDLE_NAME, args, formMsgEx);
        }
    }
}

