/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siapi;

import com.ibm.siapi.SiapiMessage;
import com.ibm.siapi.SiapiMessageArg;
import com.ibm.siapi.common.NameValuePair;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SiapiException
extends Exception {
    public static final int TYPE_UNKNOWN_ERROR = 1;
    public static final int TYPE_IO_ERROR = 6;
    public static final int TYPE_UNSUPPORTED_OPERATION = 8;
    public static final int TYPE_QUERY_SYNTAX_ERROR = 15;
    public static final int TYPE_COMMUNICATION_ERROR = 20;
    public static final int TYPE_DOCUMENT_ERROR = 21;
    public static final int TYPE_INDEX_ERROR = 22;
    public static final int TYPE_PARAMETER_ERROR = 23;
    public static final int TYPE_PROCESSING_ERROR = 24;
    public static final int TYPE_SEARCH_ENGINE_ERROR = 25;
    public static final int TYPE_SECURITY_ERROR = 26;
    public static final int TYPE_TIMED_OUT_ERROR = 27;
    public static final int SEVERITY_ERROR = 1;
    public static final int SEVERITY_FATAL_ERROR = 2;
    public static final int TYPE_DOC_EXIST_ERROR = 2;
    public static final int TYPE_DOC_NOT_FOUND_ERROR = 3;
    public static final int TYPE_SEARCH_ENGINE_STATE_ERROR = 4;
    public static final int TYPE_ILLEGAL_VALUE_ERROR = 5;
    public static final int TYPE_IMPL_FACTORY_ERROR = 7;
    public static final int TYPE_INDEX_DOES_NOT_EXIST = 9;
    public static final int TYPE_TOO_MANY_VALUES = 10;
    public static final int TYPE_TOO_FEW_VALUES = 11;
    public static final int TYPE_ILLEGAL_RESULTS_RANGE = 12;
    public static final int TYPE_INDEX_CORRUPTED = 13;
    public static final int TYPE_UKNOWN_ENCODING = 14;
    public static final int TYPE_SEARCH_ENGINE_UNAVAILABLE = 16;
    public static final int TYPE_SEARCH_ENGINE_BUSY = 17;
    public static final int TYPE_OPERATION_TIMED_OUT = 18;
    public static final int TYPE_ACL_SYNTAX_ERROR = 19;
    private int type;
    private ArrayList arguments = new ArrayList();
    private List msgList = new ArrayList();
    private static final String SIAPI_RES_BUNDLE_NAME = "com.ibm.siapi.SiapiResources";
    private static final String MSG_INTERNAL_ERR = "SIAPI0104E";
    private static final int TYPE_LAST_ENTRY = 18;
    private static final String[] TYPE_MSG_IDS = new String[]{"SIAPI0001E", "SIAPI0002E", "SIAPI0003E", "SIAPI0004E", "SIAPI0005E", "SIAPI0006E", "SIAPI0007E", "SIAPI0008E", "SIAPI0009E", "SIAPI0010E", "SIAPI0011E", "SIAPI0012E", "SIAPI0013E", "SIAPI0014E", "SIAPI0015E", "SIAPI0016E", "SIAPI0017E", "SIAPI0018E"};
    private static final String[] SEVERITY_NAMES = new String[]{"Error", "Fatal error", "Warning", "Informational"};

    public SiapiException(int severity, int type, String msgID, String resBundleName) {
        this.type = type;
        SiapiMessage msg = new SiapiMessage(severity, msgID, resBundleName);
        this.msgList.add(msg);
    }

    public SiapiException(int severity, int type, String msgID, String resBundleName, Throwable relatedCause) {
        this.type = type;
        SiapiMessage msg = new SiapiMessage(severity, msgID, resBundleName, relatedCause);
        this.msgList.add(msg);
    }

    public SiapiException(int severity, int type, String msgID, String resBundleName, SiapiMessageArg[] msgArgs) {
        this.type = type;
        SiapiMessage msg = new SiapiMessage(severity, msgID, resBundleName, msgArgs);
        this.msgList.add(msg);
    }

    public SiapiException(int severity, int type, String msgID, String resBundleName, SiapiMessageArg[] msgArgs, Throwable relatedCause) {
        this.type = type;
        SiapiMessage msg = new SiapiMessage(severity, msgID, resBundleName, msgArgs, relatedCause);
        this.msgList.add(msg);
    }

    public SiapiException(int type, SiapiMessage msg) {
        this.type = type;
        this.msgList.add(msg);
    }

    public SiapiException(int severity, int type, String messageText) {
        this.type = type;
        SiapiMessage msg = new SiapiMessage(severity, messageText);
        this.msgList.add(msg);
    }

    public SiapiException(int severity, int type, String messageText, Throwable relatedCause) {
        this.type = type;
        SiapiMessage msg = new SiapiMessage(severity, messageText, relatedCause);
        this.msgList.add(msg);
    }

    public SiapiMessage getMessageObject() {
        try {
            return (SiapiMessage)this.msgList.get(0);
        }
        catch (Exception ex) {
            SiapiMessageArg[] args = new SiapiMessageArg[]{new SiapiMessageArg(ex.toString())};
            SiapiMessage msg = new SiapiMessage(1, MSG_INTERNAL_ERR, SIAPI_RES_BUNDLE_NAME, args);
            return msg;
        }
    }

    public int getSeverity() {
        return this.getMessageObject().getSeverity();
    }

    public int getType() {
        return this.type;
    }

    public List getMessages() {
        return this.msgList;
    }

    public void addMessage(SiapiMessage msg) {
        this.msgList.add(msg);
    }

    public ArrayList getArguments() {
        return this.arguments;
    }

    public void addArgument(NameValuePair arg) {
        this.arguments.add(arg);
    }

    public String getMessage() {
        try {
            return this.getMessageObject().getMessage(true);
        }
        catch (SiapiException siapiEx) {
            try {
                return siapiEx.getMessageObject().getMessage(true);
            }
            catch (SiapiException siapiEx2) {
                return this.toString();
            }
        }
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public void printStackTrace() {
        super.printStackTrace(System.err);
        if (this.getMessageObject().getCause() != null) {
            this.getMessageObject().getCause().printStackTrace(System.err);
        }
    }

    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.getMessageObject().getCause() != null) {
            this.getMessageObject().getCause().printStackTrace(out);
        }
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.getMessageObject().getCause() != null) {
            this.getMessageObject().getCause().printStackTrace(out);
        }
    }

    public String toString() {
        StringBuffer data = new StringBuffer();
        int i = 0;
        data.append("com.ibm.siapi.SiapiException: ");
        i = 0;
        while (i < this.msgList.size()) {
            SiapiMessage smsg = (SiapiMessage)this.msgList.get(i);
            data.append("Message" + i + ": " + smsg.toString());
            ++i;
        }
        i = 0;
        while (i < this.arguments.size()) {
            NameValuePair arg = (NameValuePair)this.arguments.get(i);
            data.append("Argument" + i + ": " + arg.getName() + "=" + arg.getValue());
            ++i;
        }
        return data.toString();
    }

    public SiapiException(int severity, int type) {
        this(severity, type, (Throwable)null, (NameValuePair)null);
    }

    public SiapiException(int severity, int type, Throwable embeddedError) {
        this(severity, type, embeddedError, null);
    }

    public SiapiException(int severity, int type, Throwable embeddedError, NameValuePair arg) {
        this.type = type;
        if (type < 1 || type > 18) {
            this.type = 1;
        }
        SiapiMessage msg = new SiapiMessage(severity, TYPE_MSG_IDS[this.type - 1], SIAPI_RES_BUNDLE_NAME);
        if (embeddedError != null) {
            msg.setCause(embeddedError);
        }
        this.msgList.add(msg);
        if (arg != null) {
            this.arguments.add(arg);
        }
    }

    public String getSeverityDescription() {
        int newSev = this.getSeverity();
        if (newSev < 1 || newSev > 4) {
            newSev = 1;
        }
        return SEVERITY_NAMES[newSev - 1];
    }

    public String getTypeDescription() {
        return this.getMessage();
    }
}

