/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.util.text;

public abstract class VisualTextUtil {
    public static String getFirstLineSubstring(String text) {
        int pos = VisualTextUtil.getNextLineStartPos(text, 0);
        if (pos == -1) {
            return text;
        }
        return text.substring(0, pos);
    }

    public static String getCurrentLineSubstring(String text, int pos) {
        return VisualTextUtil.getFirstLineSubstring(text.substring(VisualTextUtil.getLineStartPos(text, pos)));
    }

    public static int getLineStartPos(String text, int pos) {
        int carriageReturnPos = text.lastIndexOf(13, pos);
        int newLinePos = text.lastIndexOf(10, pos);
        int result = carriageReturnPos == -1 || carriageReturnPos < newLinePos ? newLinePos : carriageReturnPos;
        return result + 1;
    }

    public static int getNextLineStartPos(String text, int pos) {
        int carriageReturnPos = text.indexOf(13, pos);
        int newLinePos = text.indexOf(10, pos);
        if (carriageReturnPos == -1 && newLinePos == -1) {
            return -1;
        }
        return (carriageReturnPos > newLinePos ? carriageReturnPos : newLinePos) + 1;
    }

    public static int getPrevLineStartPos(String text, int pos) {
        int carriageReturnPos = text.lastIndexOf(13, pos);
        int newLinePos = text.lastIndexOf(10, pos);
        if (carriageReturnPos == -1 && newLinePos == -1) {
            return -1;
        }
        int endLinePos = carriageReturnPos == -1 || newLinePos < carriageReturnPos ? newLinePos : carriageReturnPos;
        if (endLinePos > 0) {
            --endLinePos;
        }
        return VisualTextUtil.getLineStartPos(text, endLinePos);
    }

    public static int getVisualOffset(String text, int tabWidth, int pos) {
        int lineStartPos;
        int result = 0;
        int i = lineStartPos = VisualTextUtil.getLineStartPos(text, pos);
        while (i < pos) {
            result += text.charAt(i) == '\t' ? tabWidth : 1;
            ++i;
        }
        return result;
    }

    public static int getPosition(String text, int tabWidth, int lineStartPos, int endPos, int visualOffset) {
        int result = lineStartPos;
        while (visualOffset > 0 && result < endPos) {
            visualOffset -= text.charAt(result) == '\t' ? tabWidth : 1;
            ++result;
        }
        if (result == endPos) {
            return -1;
        }
        return result;
    }
}

