/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.util.intervals;

import com.ibm.supa.annotator.util.intervals.IntervalsContainer;
import com.ibm.supa.annotator.util.text.location.CharOffsetLocation;
import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.supa.annotator.util.text.location.IntervalImpl;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IntervalsContainerImpl
implements IntervalsContainer {
    private List<Integer> startPoints = new LinkedList<Integer>();
    private List<Integer> endPoints = new LinkedList<Integer>();

    public Interval findIntervalStart(Interval interval) {
        CharOffsetLocation start = (CharOffsetLocation)interval.getStart();
        int index = this.findIndexOfStart(start.getOffset());
        if (index == -1) {
            return null;
        }
        return new IntervalImpl(new CharOffsetLocation(this.getStart(index)), new CharOffsetLocation(this.getEnd(index)));
    }

    public void addInterval(Interval interval) {
        CharOffsetLocation start = (CharOffsetLocation)interval.getStart();
        CharOffsetLocation end = (CharOffsetLocation)interval.getEnd();
        int index = this.findIndexOfStart(start.getOffset());
        this.startPoints.add(index + 1, new Integer(start.getOffset()));
        this.endPoints.add(index + 1, new Integer(end.getOffset()));
    }

    private int findIndexOfStart(int start) {
        int index = -1;
        Iterator<Integer> it = this.startPoints.iterator();
        boolean found = false;
        while (it.hasNext()) {
            ++index;
            int now = it.next();
            if (now <= start) continue;
            found = true;
            break;
        }
        if (found) {
            return index - 1;
        }
        return index;
    }

    private int getStart(int index) {
        return this.startPoints.get(index);
    }

    private int getEnd(int index) {
        return this.endPoints.get(index);
    }
}

