/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.AnnotatorExceptionUtil;
import com.ibm.supa.annotator.util.AnnotatorUtil;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContextException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TypeEntry {
    public final PatternInfo[] mPatternsInfo;
    public final Type mCasType;
    public final boolean mRunTillNoAnnotationsAdded;
    public final Type mStartingCasType;
    public final LimittingCASType[] mLimittingCasTypes;
    public final StackInfo mStackInfo;
    public final FilteringCASType[] mFilteringCasTypes;
    public final boolean mFilterIsAncestorOfType;
    public final FilteringPattern[] mFilteringPatterns;
    public final PatternInfo mFirstScanPattern;
    public final String mSaveFilteredTextName;
    public final String mLoadFilteredTextName;

    public TypeEntry(PatternInfo[] patternsInfo, Type casType, boolean runTillNoAnnotationsAdded, Type startingCasType, LimittingCASType[] limittingCasTypes, StackInfo stackInfo, FilteringCASType[] filteringCasTypes, boolean filterIsAncestorOfType, FilteringPattern[] filteringPatterns, PatternInfo firstScanPattern, String saveFilteredTextName, String loadFilteredTextName) {
        this.mPatternsInfo = patternsInfo;
        this.mCasType = casType;
        this.mRunTillNoAnnotationsAdded = runTillNoAnnotationsAdded;
        this.mStartingCasType = startingCasType;
        this.mLimittingCasTypes = limittingCasTypes;
        this.mStackInfo = stackInfo;
        this.mFilteringCasTypes = filteringCasTypes;
        this.mFilterIsAncestorOfType = filterIsAncestorOfType;
        this.mFilteringPatterns = filteringPatterns;
        this.mFirstScanPattern = firstScanPattern;
        this.mSaveFilteredTextName = saveFilteredTextName;
        this.mLoadFilteredTextName = loadFilteredTextName;
    }

    static class PatternPair {
        private final Pattern mPattern;
        private final String mPatternStr;

        public PatternPair(Pattern pattern, String patternStr) {
            this.mPatternStr = patternStr;
            this.mPattern = pattern;
        }

        public boolean needsDynamicPatternExpansion() {
            return this.mPattern == null;
        }

        public Pattern getPattern() {
            return this.mPattern;
        }

        public String getPatternStr() {
            return this.mPatternStr;
        }
    }

    static class FilteringPattern {
        private final PatternPair mPattern;
        private final boolean mReplaceWithSpace;

        public FilteringPattern(PatternPair pattern, boolean replaceWithSpace) {
            this.mPattern = pattern;
            this.mReplaceWithSpace = replaceWithSpace;
        }

        public String replaceWith() {
            if (this.mReplaceWithSpace) {
                return new String(" ");
            }
            return new String("");
        }

        public PatternPair getPatternPair() {
            return this.mPattern;
        }
    }

    static class FilteringCASType {
        private final Type mType;
        private final boolean mReplaceWithSpace;

        public FilteringCASType(Type type, boolean replaceWithSpace) {
            this.mType = type;
            this.mReplaceWithSpace = replaceWithSpace;
        }

        public Type getType() {
            return this.mType;
        }

        public String replaceWith() {
            if (this.mReplaceWithSpace) {
                return new String(" ");
            }
            return new String("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PatternInfo {
        private final PatternPair mPattern;
        private final Integer mTypeGroupNum;
        private final HashMap<String, Integer> mFeaturesGroupConfig;

        public PatternInfo(PatternPair pattern, Integer typeGroupNum, HashMap<String, Integer> featuresGroupConfig) {
            this.mPattern = pattern;
            this.mTypeGroupNum = typeGroupNum;
            this.mFeaturesGroupConfig = featuresGroupConfig;
        }

        public HashMap<String, Integer> getFeaturesGroupConfig() {
            return this.mFeaturesGroupConfig;
        }

        public int getTypeGroupNum() {
            return this.mTypeGroupNum;
        }

        public PatternPair getPatternPair() {
            return this.mPattern;
        }
    }

    static class LimittingCASType {
        private final Type mType;
        private final Limitation mLimitation;
        private final boolean mInclusive;
        private final boolean mLimitsEntireInterval;

        public LimittingCASType(Type type, Limitation limitation, boolean inclusive, boolean limitsEntireInterval) {
            this.mType = type;
            this.mLimitation = limitation;
            this.mInclusive = inclusive;
            this.mLimitsEntireInterval = limitsEntireInterval;
        }

        public Type getType() {
            return this.mType;
        }

        public boolean isInclusive() {
            return this.mInclusive;
        }

        public Limitation getLimitation() {
            return this.mLimitation;
        }

        public boolean limitsEntireInterval() {
            return this.mLimitsEntireInterval;
        }

        public boolean excludes(int start, int end, int otherStart, int otherEnd) {
            return LimittingCASType.excludes(this.mLimitation, this.mInclusive, start, end, otherStart, otherEnd);
        }

        private static boolean excludes(Limitation limitation, boolean inclusive, int start, int end, int otherStart, int otherEnd) {
            boolean result = LimittingCASType.isExcludedBy(limitation, start, end, otherStart, otherEnd);
            if (inclusive) {
                result = !result;
            }
            return result;
        }

        private static boolean isExcludedBy(Limitation limitation, int start, int end, int otherStart, int otherEnd) {
            if (limitation == Limitation.START) {
                return otherStart <= start && start < otherEnd;
            }
            if (limitation == Limitation.END) {
                return otherStart < end && end <= otherEnd;
            }
            if (limitation == Limitation.WITHIN) {
                return LimittingCASType.isExcludedBy(Limitation.START, start, end, otherStart, otherEnd) && LimittingCASType.isExcludedBy(Limitation.END, start, end, otherStart, otherEnd);
            }
            if (limitation == Limitation.WITHOUT) {
                return LimittingCASType.isExcludedBy(Limitation.WITHIN, otherStart, otherEnd, start, end);
            }
            throw new IllegalArgumentException("Unknown limitation type " + limitation);
        }

        static final class Limitation {
            static final Limitation INTERSECT = new Limitation();
            static final Limitation START = new Limitation();
            static final Limitation END = new Limitation();
            static final Limitation WITHIN = new Limitation();
            static final Limitation WITHOUT = new Limitation();

            private Limitation() {
            }
        }
    }

    static class StackInfo {
        private final PatternPair mPushPattern;
        private final PatternPair mPopPattern;
        private final PatternPair mBothPatterns;
        private final RangingMethod mRangingMethod;
        private final boolean mEraseRange;

        public StackInfo(PatternPair pushPattern, PatternPair popPattern, PatternPair bothPatterns, RangingMethod rangingMethod, boolean eraseRange) {
            this.mPushPattern = pushPattern;
            this.mPopPattern = popPattern;
            this.mBothPatterns = bothPatterns;
            this.mRangingMethod = rangingMethod;
            this.mEraseRange = eraseRange;
        }

        public RangingMethod getRangingMethod() {
            return this.mRangingMethod;
        }

        public boolean getEraseRangeFlag() {
            return this.mEraseRange;
        }

        public PatternPair getPushPatternPair() {
            return this.mPushPattern;
        }

        public PatternPair getPopPatternPair() {
            return this.mPopPattern;
        }

        public PatternPair getBothPatternPair() {
            return this.mBothPatterns;
        }

        static final class RangingMethod {
            static final RangingMethod Push_Pop = new RangingMethod();
            static final RangingMethod PushInclude_Pop = new RangingMethod();
            static final RangingMethod Push_PopInclude = new RangingMethod();
            static final RangingMethod PushInclude_PopInclude = new RangingMethod();

            private RangingMethod() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private final Logger mLogger;
        private Builder[] mBuilders;

        public Factory(Logger logger, String pFileType, TypeSystem pTypeSystem, AnnotatorContext pCtx, File pBaseDir) throws AnnotatorConfigurationException, AnnotatorContextException, AnnotatorInitializationException {
            this.mLogger = logger;
            this.loadPatternConfig(pFileType, pCtx, pBaseDir);
            this.initTypeSystem(pTypeSystem);
            this.buildStackPatterns();
            this.buildFilteringPatterns();
            this.buildFirstScanPattern();
        }

        public TypeEntry[] buildTypeEntries() {
            TypeEntry[] result = new TypeEntry[this.mBuilders.length];
            int i = 0;
            while (i < result.length) {
                result[i] = this.mBuilders[i].build();
                ++i;
            }
            return result;
        }

        void initTypeSystem(TypeSystem pTypeSystem) throws AnnotatorInitializationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].initTypeSystem(pTypeSystem);
                this.mBuilders[i].checkIfFilterIsAncestorOfType(pTypeSystem);
                ++i;
            }
        }

        void buildStackPatterns() throws AnnotatorConfigurationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                if (this.mBuilders[i].needStack) {
                    this.mBuilders[i].buildStackPatterns();
                }
                ++i;
            }
        }

        void buildFilteringPatterns() throws AnnotatorConfigurationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].buildFilteringPatterns();
                ++i;
            }
        }

        void buildFirstScanPattern() throws AnnotatorConfigurationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].buildFirstScanPattern();
                ++i;
            }
        }

        private void loadPatternConfig(String pFileType, AnnotatorContext pCtx, File pBaseDir) throws AnnotatorContextException, AnnotatorConfigurationException {
            String[] patternStrings = (String[])pCtx.getConfigParameterValue(pFileType, "Patterns");
            String[] typeNames = (String[])pCtx.getConfigParameterValue(pFileType, "TypeNames");
            String patternFile = (String)pCtx.getConfigParameterValue(pFileType, "PatternFile");
            if (patternStrings != null && (typeNames == null || typeNames.length != patternStrings.length)) {
                throw AnnotatorExceptionUtil.getConf("type pattern array length mismatch");
            }
            if (patternStrings != null && patternStrings.length > 0) {
                this.mBuilders = new Builder[patternStrings.length];
                int i = 0;
                while (i < this.mBuilders.length) {
                    this.mBuilders[i] = new Builder(typeNames[i], patternStrings[i]);
                    ++i;
                }
            } else {
                ArrayList<Builder> buildersArray = new ArrayList<Builder>();
                this.readPatternsFromFile(pFileType, pBaseDir, patternFile, buildersArray);
                this.mBuilders = buildersArray.toArray(new Builder[buildersArray.size()]);
            }
            if (this.mBuilders.length == 0) {
                this.mLogger.warning("No pattern configuration found for group " + pFileType);
            }
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].buildPatternsInfo();
                ++i;
            }
        }

        private void addRule(String name, String value, HashMap<String, String> rules) throws AnnotatorConfigurationException {
            int openParentheses = name.indexOf("[");
            int closeParentheses = name.indexOf("]");
            if (openParentheses != -1 && closeParentheses != -1) {
                String ruleName = name.substring(0, openParentheses);
                String ruleNumberStr = name.substring(openParentheses + 1, closeParentheses);
                int ruleNumberInt = Integer.parseInt(ruleNumberStr);
                ruleNumberStr = Integer.toString(--ruleNumberInt);
                String nextNameInValue = "+" + ruleName + "[" + ruleNumberStr + "]";
                if (value.indexOf(nextNameInValue) != -1) {
                    String recursiveRule = "\\(\\+T\\[" + ruleNumberStr + "\\]\\)";
                    value = this.expandRule(value, recursiveRule, rules);
                    this.expandRecursiveRule(name, value, ruleName, ruleNumberStr, rules);
                } else if (rules.put(name, value = Builder.expandPattern(value, rules)) != null) {
                    this.mLogger.info("Rule redefined -  +" + name + ":\t" + value);
                }
            } else if (rules.put(name, value = Builder.expandPattern(value, rules)) != null) {
                this.mLogger.info("Rule redefined -  +" + name + ":\t" + value);
            }
        }

        private String expandRule(String rule, String recursiveRule, HashMap<String, String> rules) throws AnnotatorConfigurationException {
            Pattern recursiveRulePattern = Pattern.compile(recursiveRule);
            String nextToExpand = rule;
            String expandedPattern = "";
            StringBuffer expandedToReturnBuf = new StringBuffer();
            int loopCounter = 0;
            int matcherStart = 0;
            int matcherEnd = 0;
            int end = rule.length();
            int lastRecursiveRule = 0;
            while (loopCounter < 10000) {
                Matcher matcher = recursiveRulePattern.matcher(nextToExpand);
                if (!matcher.find()) break;
                matcherStart = matcher.start();
                matcherEnd = matcher.end();
                lastRecursiveRule += matcherEnd;
                expandedPattern = Builder.expandPattern(nextToExpand.substring(0, matcherStart), rules);
                expandedToReturnBuf.append(expandedPattern);
                expandedToReturnBuf.append(nextToExpand.substring(matcher.start(), matcherEnd));
                nextToExpand = nextToExpand.substring(matcherEnd, nextToExpand.length());
                ++loopCounter;
            }
            if (lastRecursiveRule != end) {
                expandedPattern = Builder.expandPattern(rule.substring(lastRecursiveRule, end), rules);
                expandedToReturnBuf.append(expandedPattern);
                return expandedToReturnBuf.toString();
            }
            return expandedToReturnBuf.toString();
        }

        private void expandRecursiveRule(String name, String value, String ruleName, String ruleNumberStr, HashMap<String, String> rules) throws AnnotatorConfigurationException {
            int ruleNumberInt;
            HashMap<String, String> recursiveRuleMap = new HashMap<String, String>();
            recursiveRuleMap.put(name, value);
            int i = ruleNumberInt = Integer.parseInt(ruleNumberStr);
            while (i > 0) {
                name = String.valueOf(ruleName) + "[" + ruleNumberStr + "]";
                String currentNameInValue = "\\+" + ruleName + "\\[" + ruleNumberStr + "\\]";
                ruleNumberStr = Integer.toString(--ruleNumberInt);
                String nextNameInValue = "\\+" + ruleName + "\\[" + ruleNumberStr + "\\]";
                value = value.replaceAll(currentNameInValue, nextNameInValue);
                recursiveRuleMap.put(name, value);
                --i;
            }
            name = String.valueOf(ruleName) + "[" + ruleNumberStr + "]";
            if (rules.containsKey(name)) {
                recursiveRuleMap.put(name, rules.get(name));
            } else {
                recursiveRuleMap.put(name, " ");
            }
            i = 1;
            while (i < recursiveRuleMap.size()) {
                name = String.valueOf(ruleName) + "[" + Integer.toString(i) + "]";
                value = (String)recursiveRuleMap.get(name);
                value = Builder.expandPattern(value, recursiveRuleMap);
                recursiveRuleMap.put(name, value);
                ++i;
            }
            if (rules.put(name, (String)recursiveRuleMap.get(name)) != null) {
                this.mLogger.info("Rule redefined -  +" + name + ":\t" + value);
            }
        }

        private boolean checkName(String name) {
            Pattern namePattern = Pattern.compile("\\A[_a-zA-Z][_a-zA-Z0-9]*(\\[[0-9]+\\])?\\z");
            Matcher matcher = namePattern.matcher(name);
            return matcher.find();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readPatternsFromFile(String pFileType, File pBaseDir, String pPatternFile, ArrayList<Builder> pBuildersArray) throws AnnotatorConfigurationException {
            if (pPatternFile == null) {
                return;
            }
            String url = pPatternFile.trim();
            if (url.length() == 0) {
                return;
            }
            File urlFile = pBaseDir == null ? new File(url) : new File(pBaseDir, url);
            HashMap<String, String> rules = new HashMap<String, String>();
            BufferedReader reader = null;
            try {
                try {
                    Builder current = null;
                    reader = new BufferedReader(new FileReader(urlFile.getAbsolutePath()));
                    String line = reader.readLine();
                    boolean pushIncludeFlag = false;
                    boolean pushLineEncountered = false;
                    boolean multiLineComment = false;
                    int multiLineCommentOpenCloseCounter = 0;
                    while (line != null) {
                        if (!line.startsWith("#") && line.length() > 0 && !Character.isWhitespace(line.charAt(0))) {
                            if (multiLineComment) {
                                if (line.startsWith("--#")) {
                                    if (--multiLineCommentOpenCloseCounter < 0) {
                                        multiLineCommentOpenCloseCounter = 0;
                                    }
                                    if (multiLineCommentOpenCloseCounter == 0) {
                                        multiLineComment = false;
                                    }
                                }
                            } else if (!line.startsWith("--#")) {
                                if (line.startsWith("%") || line.startsWith("*")) {
                                    int index = line.indexOf(":");
                                    pushLineEncountered = false;
                                    current = index != -1 ? new Builder(line.substring(1, index).trim()) : new Builder(line.substring(1).trim());
                                    pBuildersArray.add(current);
                                    if (index != -1) {
                                        String[] patternsTypeGroup = line.substring(index + 1).trim().split(",");
                                        int i = 0;
                                        while (i < patternsTypeGroup.length) {
                                            patternsTypeGroup[i] = patternsTypeGroup[i].trim();
                                            if (patternsTypeGroup[i].compareTo("") != 0) {
                                                current.typeGroupsForPatterns.add(new Integer(patternsTypeGroup[i]));
                                            } else {
                                                current.typeGroupsForPatterns.add(new Integer(1));
                                            }
                                            ++i;
                                        }
                                    }
                                    if (line.startsWith("*")) {
                                        current.runTillNoAnnotationsAdded = true;
                                        current.filteringTypeNames.add(current.typeName);
                                        current.filteringTypeReplaceWithSpace.add(new Boolean(false));
                                    }
                                } else if (line.startsWith("@")) {
                                    int index = line.indexOf(":");
                                    if (index == -1 || index == line.length() - 1) {
                                        throw AnnotatorExceptionUtil.getConf("badly formed feature group config", line);
                                    }
                                    String featureName = line.substring(1, index).trim();
                                    String featureGroupConfig = line.substring(index + 1).trim();
                                    current.featuresGroupsForPatterns.put(featureName, featureGroupConfig);
                                } else if (line.startsWith("?")) {
                                    current.startingTypeName = line.substring(1).trim();
                                } else if (line.startsWith("FIRST_SCAN")) {
                                    Pattern commandP = Pattern.compile("FIRST_SCAN(?:\\(([0-9]+)\\))?:");
                                    Matcher commandM = commandP.matcher(line);
                                    commandM.find();
                                    String groupNum = new String("1");
                                    if (commandM.group(1) != null) {
                                        groupNum = line.substring(commandM.start(1), commandM.end(1));
                                    }
                                    line = line.replaceFirst("FIRST_SCAN(?:\\([0-9]+\\))?:\\s*", "");
                                    line = line.trim();
                                    current.firstScanCapturedGroup = new Integer(groupNum);
                                    current.firstScanPatternString = line;
                                } else if (line.startsWith("ERASE_RANGE:")) {
                                    line = line.replaceFirst("ERASE_RANGE:\\s*", "");
                                    current.eraseStackRange = (line = line.trim()).equals("TRUE") ? true : (line.equals("FALSE") ? false : false);
                                } else if (line.startsWith("PUSH:")) {
                                    pushLineEncountered = true;
                                    line = line.replaceFirst("PUSH:\\s*", "");
                                    current.pushPatternString = line = line.trim();
                                    pushIncludeFlag = false;
                                } else if (line.startsWith("PUSH_INCLUDE:")) {
                                    pushLineEncountered = true;
                                    line = line.replaceFirst("PUSH_INCLUDE:\\s*", "");
                                    current.pushPatternString = line = line.trim();
                                    pushIncludeFlag = true;
                                } else if (line.startsWith("POP:")) {
                                    if (pushLineEncountered) {
                                        current.needStack = true;
                                    }
                                    line = line.replaceFirst("POP:\\s*", "");
                                    current.popPatternString = line = line.trim();
                                    current.rangingMethod = pushIncludeFlag ? StackInfo.RangingMethod.PushInclude_Pop : StackInfo.RangingMethod.Push_Pop;
                                } else if (line.startsWith("POP_INCLUDE:")) {
                                    if (pushLineEncountered) {
                                        current.needStack = true;
                                    }
                                    line = line.replaceFirst("POP_INCLUDE:\\s*", "");
                                    current.popPatternString = line = line.trim();
                                    current.rangingMethod = pushIncludeFlag ? StackInfo.RangingMethod.PushInclude_PopInclude : StackInfo.RangingMethod.Push_PopInclude;
                                } else if (line.startsWith("=") || line.startsWith("!")) {
                                    if (line.length() > 1) {
                                        Boolean limitsEntireInterval = Boolean.FALSE;
                                        if (line.charAt(1) == '&') {
                                            current.limitations.add(LimittingCASType.Limitation.INTERSECT);
                                            limitsEntireInterval = Boolean.TRUE;
                                        } else if (line.charAt(1) == '<') {
                                            current.limitations.add(LimittingCASType.Limitation.START);
                                        } else if (line.charAt(1) == '>') {
                                            current.limitations.add(LimittingCASType.Limitation.END);
                                        } else if (line.charAt(1) == '-') {
                                            current.limitations.add(LimittingCASType.Limitation.WITHIN);
                                        } else {
                                            if (line.charAt(1) != '+') throw AnnotatorExceptionUtil.getConf("undefined limitation requested", line);
                                            current.limitations.add(LimittingCASType.Limitation.WITHOUT);
                                        }
                                        current.limittingTypeNames.add(line.substring(2).trim());
                                        current.limitInclusives.add(line.startsWith("="));
                                        current.limitsEntireIntervals.add(limitsEntireInterval);
                                    }
                                } else if (line.startsWith("-")) {
                                    int index = line.lastIndexOf(":");
                                    if (index == -1 || index == line.length() - 1) {
                                        throw AnnotatorExceptionUtil.getConf("badly formed filtering request", line);
                                    }
                                    String replacedCharStr = "";
                                    if (line.startsWith("--")) {
                                        String filterPatternString = line.substring(2, index).trim();
                                        replacedCharStr = line.substring(index + 1).trim();
                                        if (!replacedCharStr.startsWith("'") || !replacedCharStr.endsWith("'") || replacedCharStr.length() < 2 || replacedCharStr.length() > 3) {
                                            throw AnnotatorExceptionUtil.getConf("badly formed filtering pattern request", line);
                                        }
                                        replacedCharStr = replacedCharStr.length() == 3 ? replacedCharStr.substring(1, 2) : "";
                                        current.filteringPatternStrings.add(filterPatternString);
                                        if (replacedCharStr.equals("")) {
                                            current.filteringPatternReplaceWithSpace.add(new Boolean(false));
                                        } else {
                                            if (!replacedCharStr.equals(" ")) throw AnnotatorExceptionUtil.getConf("badly formed filtering pattern request", line);
                                            current.filteringPatternReplaceWithSpace.add(new Boolean(true));
                                        }
                                    } else {
                                        String filterCASTypeName = line.substring(1, index).trim();
                                        replacedCharStr = line.substring(index + 1).trim();
                                        if (!replacedCharStr.startsWith("'") || !replacedCharStr.endsWith("'") || replacedCharStr.length() < 2 || replacedCharStr.length() > 3) {
                                            throw AnnotatorExceptionUtil.getConf("badly formed filtering Cas type request", line);
                                        }
                                        replacedCharStr = replacedCharStr.length() == 3 ? replacedCharStr.substring(1, 2) : "";
                                        current.filteringTypeNames.add(filterCASTypeName);
                                        if (replacedCharStr.equals("")) {
                                            current.filteringTypeReplaceWithSpace.add(new Boolean(false));
                                        } else {
                                            if (!replacedCharStr.equals(" ")) throw AnnotatorExceptionUtil.getConf("badly formed filtering Cas type request", line);
                                            current.filteringTypeReplaceWithSpace.add(new Boolean(true));
                                        }
                                    }
                                } else if (line.startsWith(">")) {
                                    if (current.saveFilteredTextName != null) {
                                        this.mLogger.warning("multiple > lines found for entry " + current.typeName);
                                    }
                                    current.saveFilteredTextName = line.substring(1);
                                } else if (line.startsWith("<")) {
                                    if (current.loadFilteredTextName != null) {
                                        this.mLogger.warning("multiple < lines found for entry " + current.typeName);
                                    }
                                    current.loadFilteredTextName = line.substring(1);
                                } else if (line.startsWith("+")) {
                                    int index = line.indexOf(":");
                                    if (index == -1 || index == line.length() - 1) {
                                        throw AnnotatorExceptionUtil.getConf("badly formed rule", line);
                                    }
                                    String name = line.substring(1, index).trim();
                                    String value = line.substring(index + 1).trim();
                                    if (!this.checkName(name)) {
                                        throw AnnotatorExceptionUtil.getConf("The following is not a proper rule name", name);
                                    }
                                    this.addRule(name, value, rules);
                                } else {
                                    current.patternStrings.add(line);
                                    pushLineEncountered = false;
                                    current.expandPatterns(rules);
                                }
                            }
                        }
                        if (line.startsWith("#--")) {
                            multiLineComment = true;
                            ++multiLineCommentOpenCloseCounter;
                        }
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException ex) {
                    throw AnnotatorExceptionUtil.getConf("err file not found", (Object)pFileType, urlFile.getAbsolutePath());
                }
                catch (IOException ex) {
                    throw AnnotatorExceptionUtil.getConf("err file read", (Object)pFileType, urlFile.getAbsolutePath());
                }
            }
            catch (Throwable throwable) {
                this.closeFile(url, reader);
                throw throwable;
            }
            this.closeFile(url, reader);
        }

        private void closeFile(String fileName, BufferedReader pReader) {
            if (pReader != null) {
                try {
                    pReader.close();
                }
                catch (Exception ex) {
                    this.mLogger.log(Level.WARNING, "Failed to close file " + fileName, ex);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Builder {
            private static final int sMAX_REPLACEMENTS = 10000;
            private static final Pattern sRULE_EXPR_PATTERN = Pattern.compile("\\(\\+(?!\\+)(.*?)\\)");
            String typeName;
            String startingTypeName;
            ArrayList<String> limittingTypeNames;
            ArrayList<LimittingCASType.Limitation> limitations;
            ArrayList<Boolean> limitInclusives;
            ArrayList<Boolean> limitsEntireIntervals;
            ArrayList<String> filteringTypeNames;
            ArrayList<Boolean> filteringTypeReplaceWithSpace;
            ArrayList<String> filteringPatternStrings;
            ArrayList<Boolean> filteringPatternReplaceWithSpace;
            String firstScanPatternString;
            int firstScanCapturedGroup;
            ArrayList<String> patternStrings;
            HashMap<String, String> featuresGroupsForPatterns;
            ArrayList<Integer> typeGroupsForPatterns;
            String pushPatternString;
            String popPatternString;
            StackInfo.RangingMethod rangingMethod;
            boolean eraseStackRange;
            boolean needStack;
            String saveFilteredTextName;
            String loadFilteredTextName;
            boolean runTillNoAnnotationsAdded;
            Type casType;
            PatternInfo[] patternsInfo;
            Type startingCasType;
            Type[] nonIntersectingCasTypes;
            LimittingCASType[] limittingCasTypes;
            StackInfo stackInfo;
            FilteringCASType[] filteringCasTypes;
            boolean filterIsAncestorOfType;
            FilteringPattern[] filteringPatterns;
            PatternInfo firstScanPatternInfo;
            Pattern pushPattern;
            Pattern popPattern;

            Builder(String typeName) {
                this(typeName, null);
            }

            Builder(String typeName, String pattern) {
                this.typeName = typeName;
                this.patternStrings = new ArrayList();
                this.featuresGroupsForPatterns = new HashMap();
                this.typeGroupsForPatterns = new ArrayList();
                if (pattern != null) {
                    this.patternStrings.add(pattern);
                }
                this.startingTypeName = null;
                this.needStack = false;
                this.limittingTypeNames = new ArrayList();
                this.limitations = new ArrayList();
                this.limitInclusives = new ArrayList();
                this.limitsEntireIntervals = new ArrayList();
                this.filteringTypeNames = new ArrayList();
                this.filteringTypeReplaceWithSpace = new ArrayList();
                this.filterIsAncestorOfType = false;
                this.filteringPatternStrings = new ArrayList();
                this.filteringPatternReplaceWithSpace = new ArrayList();
                this.firstScanPatternString = null;
            }

            void expandPatterns(HashMap<String, String> rules) throws AnnotatorConfigurationException {
                if (this.patternStrings.size() == 0) {
                    throw AnnotatorExceptionUtil.getConf("err type with no patterns", this.typeName);
                }
                int i = 0;
                while (i < this.patternStrings.size()) {
                    this.patternStrings.set(i, Builder.expandPattern(this.patternStrings.get(i), rules));
                    ++i;
                }
                i = 0;
                while (i < this.filteringPatternStrings.size()) {
                    this.filteringPatternStrings.set(i, Builder.expandPattern(this.filteringPatternStrings.get(i), rules));
                    ++i;
                }
                if (this.needStack) {
                    this.pushPatternString = Builder.expandPattern(this.pushPatternString, rules);
                    this.popPatternString = Builder.expandPattern(this.popPatternString, rules);
                }
                if (this.firstScanPatternString != null) {
                    this.firstScanPatternString = Builder.expandPattern(this.firstScanPatternString, rules);
                }
            }

            private static String expandPattern(String pattern, HashMap<String, String> rules) throws AnnotatorConfigurationException {
                String temp = pattern;
                StringBuffer sBuf = new StringBuffer();
                int loopCounter = 0;
                while (loopCounter < 10000) {
                    Matcher matcher = sRULE_EXPR_PATTERN.matcher(temp);
                    if (!matcher.find()) {
                        return temp;
                    }
                    String name = matcher.group(1);
                    String value = rules.get(name);
                    if (value == null) {
                        throw AnnotatorExceptionUtil.getConf("undefined rule found in pattern", (Object)name, pattern);
                    }
                    sBuf.append(temp.substring(0, matcher.start())).append(value).append(temp.substring(matcher.end()));
                    temp = sBuf.toString();
                    sBuf.delete(0, sBuf.length());
                    ++loopCounter;
                }
                throw AnnotatorExceptionUtil.getConf("too many replacements in pattern", pattern);
            }

            void buildPatternsInfo() throws AnnotatorConfigurationException {
                if (this.typeGroupsForPatterns.size() > this.patternStrings.size()) {
                    throw AnnotatorExceptionUtil.getConf("too much group nums in type line");
                }
                this.patternsInfo = new PatternInfo[this.patternStrings.size()];
                int i = 0;
                while (i < this.patternStrings.size()) {
                    String patternString = this.patternStrings.get(i);
                    Pattern pattern = null;
                    if (patternString.indexOf("(++") == -1) {
                        try {
                            pattern = Pattern.compile(patternString);
                            if (pattern.matcher("").matches()) {
                                throw AnnotatorExceptionUtil.getConf("regex matches empty string", patternString);
                            }
                        }
                        catch (PatternSyntaxException e) {
                            throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)patternString, (Exception)e);
                        }
                    }
                    HashMap<String, Integer> featuresGroupForPattern = new HashMap<String, Integer>();
                    Iterator<String> itFVM = this.featuresGroupsForPatterns.keySet().iterator();
                    while (itFVM.hasNext()) {
                        String featureName = new String(itFVM.next());
                        String GroupConfig = new String(this.featuresGroupsForPatterns.get(featureName));
                        String[] GroupConfigByPattern = GroupConfig.split(",");
                        if (GroupConfigByPattern.length != this.patternStrings.size()) {
                            throw AnnotatorExceptionUtil.getConf("feature group config doesn't match amount of patterns", featureName);
                        }
                        if (i >= GroupConfigByPattern.length) continue;
                        GroupConfigByPattern[i] = GroupConfigByPattern[i].trim();
                        if (GroupConfigByPattern[i].compareTo("") == 0) {
                            throw AnnotatorExceptionUtil.getConf("badly formed feature group config line", featureName);
                        }
                        featuresGroupForPattern.put(featureName, new Integer(GroupConfigByPattern[i]));
                    }
                    this.patternsInfo[i] = i < this.typeGroupsForPatterns.size() ? new PatternInfo(new PatternPair(pattern, patternString), this.typeGroupsForPatterns.get(i), featuresGroupForPattern) : new PatternInfo(new PatternPair(pattern, patternString), new Integer(1), featuresGroupForPattern);
                    ++i;
                }
            }

            void buildStackPatterns() throws AnnotatorConfigurationException {
                this.pushPattern = null;
                if (this.pushPatternString.indexOf("(++") == -1) {
                    try {
                        this.pushPattern = Pattern.compile(this.pushPatternString);
                        if (this.pushPattern.matcher("").matches()) {
                            throw AnnotatorExceptionUtil.getConf("regex matches empty string", this.pushPatternString);
                        }
                    }
                    catch (PatternSyntaxException e) {
                        throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)this.pushPatternString, (Exception)e);
                    }
                }
                this.popPattern = null;
                if (this.popPatternString.indexOf("(++") == -1) {
                    try {
                        this.popPattern = Pattern.compile(this.popPatternString);
                        if (this.popPattern.matcher("").matches()) {
                            throw AnnotatorExceptionUtil.getConf("regex matches empty string", this.popPatternString);
                        }
                    }
                    catch (PatternSyntaxException e) {
                        throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)this.popPatternString, (Exception)e);
                    }
                }
                Pattern bothPatterns = null;
                String bothPatternsStr = new String("(?:" + this.pushPatternString + ")" + "|" + "(?:" + this.popPatternString + ")");
                if (this.pushPattern != null && this.popPattern != null) {
                    try {
                        bothPatterns = Pattern.compile(bothPatternsStr);
                        if (bothPatterns.matcher("").matches()) {
                            throw AnnotatorExceptionUtil.getConf("regex matches empty string", bothPatterns.pattern());
                        }
                    }
                    catch (PatternSyntaxException e) {
                        throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)bothPatterns.pattern(), (Exception)e);
                    }
                }
                this.stackInfo = new StackInfo(new PatternPair(this.pushPattern, this.pushPatternString), new PatternPair(this.popPattern, this.popPatternString), new PatternPair(bothPatterns, bothPatternsStr), this.rangingMethod, this.eraseStackRange);
            }

            void buildFilteringPatterns() throws AnnotatorConfigurationException {
                Pattern[] tempFilteringPatterns = new Pattern[this.filteringPatternStrings.size()];
                int i = 0;
                while (i < this.filteringPatternStrings.size()) {
                    String filteringPatternString = this.filteringPatternStrings.get(i);
                    tempFilteringPatterns[i] = null;
                    if (filteringPatternString.indexOf("(++") == -1) {
                        try {
                            tempFilteringPatterns[i] = Pattern.compile(filteringPatternString);
                            if (tempFilteringPatterns[i].matcher("").matches()) {
                                throw AnnotatorExceptionUtil.getConf("regex matches empty string", filteringPatternString);
                            }
                        }
                        catch (PatternSyntaxException e) {
                            throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)filteringPatternString, (Exception)e);
                        }
                    }
                    ++i;
                }
                Boolean[] filterWithSpace = this.toBooleanArray(this.filteringPatternReplaceWithSpace);
                this.filteringPatterns = new FilteringPattern[tempFilteringPatterns.length];
                int i2 = 0;
                while (i2 < this.filteringPatterns.length) {
                    this.filteringPatterns[i2] = new FilteringPattern(new PatternPair(tempFilteringPatterns[i2], this.filteringPatternStrings.get(i2)), filterWithSpace[i2]);
                    ++i2;
                }
            }

            void buildFirstScanPattern() throws AnnotatorConfigurationException {
                if (this.firstScanPatternString != null) {
                    Pattern firstScanPattern = null;
                    if (this.firstScanPatternString.indexOf("(++") == -1) {
                        try {
                            firstScanPattern = Pattern.compile(this.firstScanPatternString);
                            if (firstScanPattern.matcher("").matches()) {
                                throw AnnotatorExceptionUtil.getConf("regex matches empty string", this.firstScanPatternString);
                            }
                        }
                        catch (PatternSyntaxException e) {
                            throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)this.firstScanPatternString, (Exception)e);
                        }
                    }
                    PatternPair firstScanPatternPair = new PatternPair(firstScanPattern, this.firstScanPatternString);
                    this.firstScanPatternInfo = new PatternInfo(firstScanPatternPair, this.firstScanCapturedGroup, null);
                } else {
                    this.firstScanPatternInfo = null;
                }
            }

            void initTypeSystem(TypeSystem pTypeSystem) throws AnnotatorInitializationException {
                this.casType = AnnotatorUtil.nameToCASType(this.getClass().getName(), pTypeSystem, this.typeName, false);
                this.startingCasType = AnnotatorUtil.nameToCASType(this.getClass().getName(), pTypeSystem, this.startingTypeName, true);
                String[] names = this.toStringArray(this.limittingTypeNames);
                Type[] types = AnnotatorUtil.namesToCASTypes(this.getClass().getName(), pTypeSystem, names, false);
                this.limittingCasTypes = new LimittingCASType[types.length];
                int i = 0;
                while (i < this.limittingCasTypes.length) {
                    this.limittingCasTypes[i] = new LimittingCASType(types[i], this.limitations.get(i), this.limitInclusives.get(i), this.limitsEntireIntervals.get(i));
                    ++i;
                }
                names = this.toStringArray(this.filteringTypeNames);
                Boolean[] filterWithSpace = this.toBooleanArray(this.filteringTypeReplaceWithSpace);
                types = AnnotatorUtil.namesToCASTypes(this.getClass().getName(), pTypeSystem, names, false);
                this.filteringCasTypes = new FilteringCASType[types.length];
                int i2 = 0;
                while (i2 < this.filteringCasTypes.length) {
                    this.filteringCasTypes[i2] = new FilteringCASType(types[i2], filterWithSpace[i2]);
                    ++i2;
                }
            }

            void checkIfFilterIsAncestorOfType(TypeSystem pTypeSystem) {
                int i = 0;
                while (i < this.filteringCasTypes.length) {
                    this.filterIsAncestorOfType = pTypeSystem.subsumes(this.filteringCasTypes[i].getType(), this.casType);
                    if (this.filterIsAncestorOfType) {
                        return;
                    }
                    ++i;
                }
            }

            private String[] toStringArray(List<String> list) {
                return list == null ? null : list.toArray(new String[list.size()]);
            }

            private Boolean[] toBooleanArray(List<Boolean> list) {
                return list == null ? null : list.toArray(new Boolean[list.size()]);
            }

            private TypeEntry build() {
                return new TypeEntry(this.patternsInfo, this.casType, this.runTillNoAnnotationsAdded, this.startingCasType, this.limittingCasTypes, this.stackInfo, this.filteringCasTypes, this.filterIsAncestorOfType, this.filteringPatterns, this.firstScanPatternInfo, this.saveFilteredTextName, this.loadFilteredTextName);
            }
        }
    }
}

