/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.AnnotatorExceptionUtil;
import com.ibm.supa.annotator.annotators.BlockAnnotator;
import com.ibm.supa.annotator.annotators.ConfigurationInfo;
import com.ibm.supa.annotator.annotators.FileTypeGroupConfig;
import com.ibm.supa.annotator.annotators.FilteredText;
import com.ibm.supa.annotator.annotators.IntervalCombiner;
import com.ibm.supa.annotator.annotators.MatchInfo;
import com.ibm.supa.annotator.annotators.TypeEntry;
import com.ibm.supa.annotator.util.AnnotatorUtil;
import com.ibm.supa.annotator.util.LogUtil;
import com.ibm.supa.annotator.util.intervals.Intervals;
import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.supa.annotator.util.text.location.IntervalImpl;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.TypeOrFeature;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.analysis_engine.annotator.Annotator_ImplBase;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FSMatchConstraint;
import com.ibm.uima.cas.FSTypeConstraint;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.AnnotationIndex;
import com.ibm.uima.cas.text.TCAS;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SupaBaseAnnotator
extends Annotator_ImplBase {
    private static final int TIMEOUT_TO_END_FIND_SCAN = 10000;
    private Timer findExecutionTimer = new Timer();
    private static Logger sLogger = Logger.getLogger(LogUtil.getLogName(BlockAnnotator.class));
    private Map<CharSequence, FileTypeGroupConfig> mFileTypeGroupConfigMap;
    private Map<String, FilteredText> mFilteredTextInstances;
    private final ConfigurationInfo configInfo;

    public SupaBaseAnnotator(ConfigurationInfo configInfo) {
        this.configInfo = configInfo;
    }

    protected boolean inAnnotation(TCAS aTCAS, Type annotationType, int pos) {
        return this.getEndAnnotationPosition(aTCAS, annotationType, pos) != -1;
    }

    protected int getEndAnnotationPosition(TCAS aTCAS, Type annotationType, int pos) {
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator it = idx.iterator();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(annotationType);
        int result = -1;
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            if (fs.getBegin() <= pos && pos < fs.getEnd()) {
                result = Math.max(result, fs.getEnd());
            }
            it.moveToNext();
        }
        return result;
    }

    public final void process(TCAS aTCAS, ResultSpecification aResultSpec) throws AnnotatorProcessException {
        this.mFilteredTextInstances = new HashMap<String, FilteredText>();
        FileTypeGroupConfig[] cfgs = null;
        try {
            cfgs = this.getConfigurations(aTCAS);
            if (cfgs == null || cfgs.length == 0) {
                StringBuilder sBuf = new StringBuilder();
                List<CharSequence> fileTypes = this.configInfo.getFileTypes(aTCAS);
                if (fileTypes.isEmpty()) {
                    sBuf.append("No file types found");
                } else {
                    sBuf.append("File types (");
                    for (CharSequence seq : fileTypes) {
                        sBuf.append(seq).append(", ");
                    }
                    sBuf.setCharAt(sBuf.length() - 2, ')');
                    sBuf.append("are not supported and the file will not be analyzed");
                }
                sLogger.config(sBuf.toString());
                return;
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException((Throwable)e);
        }
        FileTypeGroupConfig[] fileTypeGroupConfigArray = cfgs;
        int n = 0;
        int n2 = fileTypeGroupConfigArray.length;
        while (n < n2) {
            FileTypeGroupConfig cfg = fileTypeGroupConfigArray[n];
            if (cfg != null) {
                this.subProcess(aTCAS, aResultSpec, cfg);
            }
            ++n;
        }
    }

    protected void saveFilteredTextInstance(TypeEntry typeEntry, FilteredText text) {
        this.mFilteredTextInstances.put(typeEntry.mSaveFilteredTextName, text);
    }

    protected abstract void subProcess(TCAS var1, ResultSpecification var2, FileTypeGroupConfig var3) throws AnnotatorProcessException;

    protected FilteredText getFilteredText(TypeEntry typeEntry, TCAS aTCAS) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        FilteredText result = null;
        boolean loadedInstance = false;
        if (typeEntry.mLoadFilteredTextName != null) {
            result = this.mFilteredTextInstances.get(typeEntry.mLoadFilteredTextName);
            loadedInstance = true;
        }
        if (result == null) {
            result = new FilteredText(aTCAS.getDocumentText());
        }
        if (typeEntry.mFilteringPatterns.length > 0) {
            result.filter();
        }
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        int i = 0;
        while (i < typeEntry.mFilteringCasTypes.length) {
            FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
            constraint.add(typeEntry.mFilteringCasTypes[i].getType());
            FSIterator it = idx.iterator();
            it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
            while (it.isValid()) {
                block13: {
                    AnnotationFS fs;
                    block12: {
                        fs = (AnnotationFS)it.get();
                        if (!loadedInstance) break block12;
                        if (result.containsInterval(fs.getBegin(), fs.getEnd(), typeEntry.mFilteringCasTypes[i].replaceWith())) break block13;
                        result = (FilteredText)result.clone();
                        loadedInstance = false;
                    }
                    result.addInterval(fs.getBegin(), fs.getEnd(), typeEntry.mFilteringCasTypes[i].replaceWith());
                }
                it.moveToNext();
            }
            ++i;
        }
        i = 0;
        while (i < typeEntry.mFilteringPatterns.length) {
            ArrayList<MatchInfo> intervalsToAnnotate = new ArrayList<MatchInfo>();
            String subText = result.getFilteredText();
            Pattern pattern = this.getPattern(aTCAS, typeEntry.mFilteringPatterns[i].getPatternPair());
            this.matchPattern(result, subText, 0, subText.length(), pattern, 1, null, false, false, intervalsToAnnotate);
            for (MatchInfo match : intervalsToAnnotate) {
                int annotStart = match.getInterval().getStart().getOffset();
                int annotEnd = match.getInterval().getEnd().getOffset();
                if (loadedInstance) {
                    if (result.containsInterval(annotStart, annotEnd, typeEntry.mFilteringPatterns[i].replaceWith())) continue;
                    result = (FilteredText)result.clone();
                    loadedInstance = false;
                }
                result.addInterval(annotStart, annotEnd, typeEntry.mFilteringPatterns[i].replaceWith());
            }
            ++i;
        }
        if (typeEntry.mFilterIsAncestorOfType && loadedInstance) {
            result = (FilteredText)result.clone();
        }
        return result;
    }

    protected List<MatchInfo> getLimittedRanges(List<MatchInfo> matchesToAnnotate, TypeEntry.LimittingCASType[] limittingTypes, boolean skipEntireIntervalLimitations, TCAS aTCAS) {
        if (limittingTypes == null || matchesToAnnotate.isEmpty()) {
            return matchesToAnnotate;
        }
        List<MatchInfo> result = matchesToAnnotate;
        int i = 0;
        while (i < limittingTypes.length) {
            if (!limittingTypes[i].limitsEntireInterval() || !skipEntireIntervalLimitations) {
                result = this.getLimittedRanges(result, limittingTypes[i], aTCAS);
            }
            ++i;
        }
        return result;
    }

    private List<MatchInfo> getLimittedRanges(List<MatchInfo> matchesToAnnotate, TypeEntry.LimittingCASType limittingType, TCAS aTCAS) {
        if (limittingType == null || matchesToAnnotate.isEmpty()) {
            return matchesToAnnotate;
        }
        List<MatchInfo> result = matchesToAnnotate;
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator it = idx.iterator();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(limittingType.getType());
        ArrayList<MatchInfo> nextResult = new ArrayList<MatchInfo>();
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            for (MatchInfo matchInfo : result) {
                int end;
                int begin = matchInfo.getInterval().getStart().getOffset();
                if (limittingType.excludes(begin, end = matchInfo.getInterval().getEnd().getOffset(), fs.getBegin(), fs.getEnd())) continue;
                nextResult.add(matchInfo);
            }
            if (!limittingType.isInclusive()) {
                result = nextResult;
                nextResult = new ArrayList();
            }
            it.moveToNext();
        }
        if (limittingType.isInclusive()) {
            result = nextResult;
        }
        return result;
    }

    private List<Interval> getRangesWithStartingAnnotation(List<Interval> ranges, Type startingType, TCAS aTCAS) {
        if (startingType == null || ranges.isEmpty()) {
            return ranges;
        }
        ArrayList<Interval> result = new ArrayList<Interval>();
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator it = idx.iterator();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(startingType);
        Iterator<Interval> rangeIt = ranges.iterator();
        Interval currentInterval = rangeIt.next();
        int begin = currentInterval.getStart().getOffset();
        int end = currentInterval.getEnd().getOffset();
        int lastStartPos = -1;
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        block0: while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            while (fs.getBegin() >= begin) {
                if (fs.getBegin() < end) {
                    if (begin == lastStartPos) break;
                    result.add(IntervalImpl.createWithCharoffsets(fs.getBegin(), end));
                    lastStartPos = fs.getBegin();
                    break;
                }
                if (!rangeIt.hasNext()) break block0;
                currentInterval = rangeIt.next();
                begin = currentInterval.getStart().getOffset();
                end = currentInterval.getEnd().getOffset();
            }
            it.moveToNext();
        }
        return result;
    }

    protected List<Interval> getRangesToAnnotate(TypeEntry typeEntry, Type[] containingTypes, boolean isSkipSubAnnotations, TCAS aTCAS) throws CASException, AnnotatorConfigurationException {
        ArrayList<Interval> inIntervalList = this.getRanges(typeEntry, containingTypes, true, true, isSkipSubAnnotations, aTCAS);
        ArrayList<Interval> exIntervalList = this.getRanges(typeEntry, null, false, false, isSkipSubAnnotations, aTCAS);
        IntervalCombiner exIntervals = new IntervalCombiner();
        for (Interval interval : exIntervalList) {
            exIntervals.addInterval(interval);
        }
        exIntervals.combine();
        List<Interval> result = inIntervalList;
        if (!exIntervals.isEmpty()) {
            ArrayList<IntervalCombiner.CombinedInterval> excluded = exIntervals.toArrayList();
            result = new ArrayList();
            int firstExIndex = 0;
            int i = 0;
            while (i < inIntervalList.size()) {
                Interval inRange = (Interval)inIntervalList.get(i);
                int firstOverlapIndex = this.getOverlapIndex(inRange, excluded, firstExIndex, inIntervalList);
                if (firstOverlapIndex == -1) {
                    result.add(inRange);
                } else {
                    firstExIndex = firstOverlapIndex;
                }
                ++i;
            }
        }
        if (typeEntry != null) {
            result = this.getRangesWithStartingAnnotation(result, typeEntry.mStartingCasType, aTCAS);
        }
        return result;
    }

    private int getOverlapIndex(Interval inRange, ArrayList<IntervalCombiner.CombinedInterval> excluded, int firstExIndex, List<Interval> incompleteIntervalList) {
        int inStart = inRange.getStart().getOffset();
        int inEnd = inRange.getEnd().getOffset();
        int result = -1;
        int j = firstExIndex;
        int count = 0;
        while (count < excluded.size()) {
            IntervalCombiner.CombinedInterval exRange = excluded.get(j);
            if (inStart < exRange.getEnd() && exRange.getStart() < inEnd) {
                if (inStart < exRange.getStart()) {
                    incompleteIntervalList.add(IntervalImpl.createWithCharoffsets(inStart, exRange.getStart()));
                }
                if (exRange.getEnd() < inEnd) {
                    incompleteIntervalList.add(IntervalImpl.createWithCharoffsets(exRange.getEnd(), inEnd));
                }
                result = j;
                break;
            }
            j = (j + 1) % excluded.size();
            ++count;
        }
        return result;
    }

    private ArrayList<Interval> getRanges(TypeEntry typeEntry, Type[] containingTypes, boolean inclusives, boolean conjoin, boolean isSkipSubAnnotations, TCAS aTCAS) throws CASException {
        int i;
        ArrayList<Interval> ranges = new ArrayList<Interval>();
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator iterator = idx.iterator();
        FSMatchConstraint constraint = null;
        if (typeEntry != null) {
            TypeEntry.LimittingCASType[] limittingTypes = typeEntry.mLimittingCasTypes;
            i = 0;
            while (i < limittingTypes.length) {
                if (limittingTypes[i].limitsEntireInterval() && limittingTypes[i].isInclusive() && inclusives || !limittingTypes[i].isInclusive() && !inclusives) {
                    Type type = limittingTypes[i].getType();
                    constraint = this.accumulateConstraint(constraint, type, conjoin, aTCAS);
                }
                ++i;
            }
        }
        if (containingTypes != null) {
            FSMatchConstraint containingConstraint = null;
            i = 0;
            while (i < containingTypes.length) {
                containingConstraint = this.accumulateConstraint(containingConstraint, containingTypes[i], false, aTCAS);
                ++i;
            }
            constraint = this.accumulateConstraint(constraint, containingConstraint, conjoin, aTCAS);
        }
        if (constraint == null) {
            if (inclusives) {
                ranges.add(IntervalImpl.createWithCharoffsets(0, aTCAS.getDocumentText().length()));
            }
            return ranges;
        }
        iterator = aTCAS.createFilteredIterator(iterator, constraint);
        while (iterator.isValid()) {
            AnnotationFS fs = (AnnotationFS)iterator.get();
            ranges.addAll(this.getSubRangesToAnnotate(isSkipSubAnnotations, idx, fs));
            iterator.moveToNext();
        }
        return ranges;
    }

    private FSMatchConstraint accumulateConstraint(FSMatchConstraint constraint, Type type, boolean conjoin, TCAS aTCAS) {
        FSTypeConstraint temp = aTCAS.getConstraintFactory().createTypeConstraint();
        temp.add(type);
        return this.accumulateConstraint((FSMatchConstraint)temp, constraint, conjoin, aTCAS);
    }

    private FSMatchConstraint accumulateConstraint(FSMatchConstraint a, FSMatchConstraint b, boolean conjoin, TCAS aTCAS) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (conjoin) {
            return aTCAS.getConstraintFactory().and(a, b);
        }
        return aTCAS.getConstraintFactory().or(a, b);
    }

    private List<IntervalImpl> getSubRangesToAnnotate(boolean isSkipSubAnnotations, AnnotationIndex idx, AnnotationFS fs) {
        ArrayList<IntervalImpl> result = new ArrayList<IntervalImpl>();
        if (!isSkipSubAnnotations) {
            result.add(IntervalImpl.createWithCharoffsets(fs.getBegin(), fs.getEnd()));
            return result;
        }
        int marker = fs.getBegin();
        FSIterator iter = idx.subiterator(fs, true, true);
        while (iter.isValid()) {
            AnnotationFS subFS = (AnnotationFS)iter.get();
            if (subFS.getBegin() > marker) {
                result.add(IntervalImpl.createWithCharoffsets(marker, subFS.getBegin()));
            }
            if (subFS.getEnd() > marker) {
                marker = subFS.getEnd();
            }
            iter.moveToNext();
        }
        if (marker < fs.getEnd()) {
            result.add(IntervalImpl.createWithCharoffsets(marker, fs.getEnd()));
        }
        return result;
    }

    protected FileTypeGroupConfig getFileTypeGroupConfig(CharSequence pFileType, TypeSystem pTypeSystem, File baseDir) throws AnnotatorConfigurationException {
        FileTypeGroupConfig result = this.mFileTypeGroupConfigMap.get(pFileType);
        if (result == null) {
            String[] allTypes = this.getContext().getConfigurationGroupNames();
            int i = 0;
            while (i < allTypes.length) {
                if (allTypes[i].equals(pFileType)) {
                    result = new FileTypeGroupConfig(pFileType.toString(), pTypeSystem, this.getContext(), baseDir);
                    this.mFileTypeGroupConfigMap.put(pFileType, result);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws AnnotatorInitializationException {
        for (FileTypeGroupConfig cfg : this.mFileTypeGroupConfigMap.values()) {
            cfg.initTypeSystem(aTypeSystem);
        }
    }

    public void initialize(AnnotatorContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(aContext);
        this.mFileTypeGroupConfigMap = new HashMap<CharSequence, FileTypeGroupConfig>();
    }

    protected List<Type> createResultTypes(ResultSpecification aResultSpec, TypeSystem typeSystem) {
        TypeOrFeature[] resultTypesOrFeatures = aResultSpec.getResultTypesAndFeatures();
        ArrayList<Type> resultTypes = new ArrayList<Type>();
        int i = 0;
        while (i < resultTypesOrFeatures.length) {
            if (resultTypesOrFeatures[i].isType()) {
                resultTypes.add(typeSystem.getType(resultTypesOrFeatures[i].getName()));
            }
            ++i;
        }
        return resultTypes;
    }

    protected boolean resultIncludesType(TypeSystem typeSystem, List<Type> resultTypes, Type type) {
        boolean includes = false;
        for (Type resultType : resultTypes) {
            if (!typeSystem.subsumes(resultType, type)) continue;
            includes = true;
            break;
        }
        return includes;
    }

    protected FileTypeGroupConfig[] getConfigurations(TCAS aTCAS) throws CASException, AnnotatorConfigurationException {
        List<CharSequence> fileTypes = this.configInfo.getFileTypes(aTCAS);
        TypeSystem typeSystem = aTCAS.getTypeSystem();
        File baseDir = this.configInfo.getBaseDir(aTCAS);
        FileTypeGroupConfig[] result = new FileTypeGroupConfig[fileTypes.size()];
        int i = 0;
        for (CharSequence fileType : fileTypes) {
            result[i++] = this.getFileTypeGroupConfig(fileType, typeSystem, baseDir);
        }
        return result;
    }

    protected void matchNestedPatterns(FilteredText text, String subText, int startPos, int endPos, Pattern firstScanPattern, int firstScanCaptureGroup, Pattern mainPattern, int mainGroupNum, HashMap<String, Integer> featureGroupConfig, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, List<MatchInfo> matchesToAnnotate) throws AnnotatorConfigurationException {
        if (firstScanPattern == null) {
            this.matchPattern(text, subText, startPos, endPos, mainPattern, mainGroupNum, featureGroupConfig, matchStartOnly, isAnnotateEntireContainingAnnotation, matchesToAnnotate);
        } else {
            ArrayList<MatchInfo> firstScanMatches = new ArrayList<MatchInfo>();
            this.matchPattern(text, subText, startPos, endPos, firstScanPattern, firstScanCaptureGroup, null, matchStartOnly, isAnnotateEntireContainingAnnotation, firstScanMatches);
            for (MatchInfo matchInfo : firstScanMatches) {
                Interval interval = matchInfo.getInterval();
                int annotStart = interval.getStart().getOffset();
                int annotEnd = interval.getEnd().getOffset();
                if ((annotStart = text.getFilteredPos(annotStart)) == -1) {
                    annotStart = text.getFloorPos() + 1;
                } else if (text.onAReplacedCharFilteredInterval() && !text.atTheStartOfTheFilteredInterval()) {
                    ++annotStart;
                }
                annotEnd = text.getFilteredPos(annotEnd);
                if (annotEnd == -1) {
                    annotEnd = text.getFloorPos() + 1;
                }
                String subSubText = text.getFilteredText().substring(annotStart, annotEnd);
                FilteredText newText = new FilteredText(subSubText);
                newText.filter();
                ArrayList<MatchInfo> matchesFound = new ArrayList<MatchInfo>();
                this.matchPattern(newText, subSubText, 0, subSubText.length(), mainPattern, mainGroupNum, featureGroupConfig, matchStartOnly, isAnnotateEntireContainingAnnotation, matchesFound);
                for (MatchInfo curMatch : matchesFound) {
                    Interval intervalOnOriginalText = text.convertToUnfilteredPos(curMatch.getInterval(), annotStart);
                    HashMap<String, Interval> curFeatureValuesMap = curMatch.getFeatureValuesMap();
                    HashMap<String, Interval> convertedFeatureValuesMap = null;
                    if (curFeatureValuesMap != null) {
                        convertedFeatureValuesMap = new HashMap<String, Interval>();
                        for (Map.Entry<String, Interval> featureEntry : curFeatureValuesMap.entrySet()) {
                            String featureName = new String(featureEntry.getKey());
                            Interval featureIntervalOnFilteredText = featureEntry.getValue();
                            Interval featureIntervalOnOriginalText = text.convertToUnfilteredPos(featureIntervalOnFilteredText, annotStart);
                            convertedFeatureValuesMap.put(featureName, featureIntervalOnOriginalText);
                        }
                    }
                    matchesToAnnotate.add(new MatchInfo(intervalOnOriginalText, convertedFeatureValuesMap));
                }
            }
        }
    }

    protected void matchPattern(FilteredText text, String subText, int startPos, int endPos, Pattern pattern, int mainGroupNum, HashMap<String, Integer> featureGroupConfig, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, List<MatchInfo> matchesToAnnotate) {
        HashMap<String, Interval> featureValuesMap = null;
        int pos = 0;
        Matcher matcher = pattern.matcher(subText);
        boolean loop = true;
        while (pos >= 0 && pos < subText.length() && loop) {
            int annotEnd;
            int annotStart;
            if (matchStartOnly) {
                loop = false;
                if (!matcher.lookingAt()) {
                    break;
                }
            } else if (this.findWithATimeOut(matcher, pos) != FindStatus.MATCH) break;
            if (isAnnotateEntireContainingAnnotation) {
                annotStart = startPos;
                annotEnd = endPos;
            } else {
                int groupLoc = 0;
                if (matcher.groupCount() >= mainGroupNum && matcher.start(1) != -1) {
                    groupLoc = mainGroupNum;
                }
                annotStart = startPos + matcher.start(groupLoc);
                annotEnd = startPos + matcher.end(groupLoc);
                if (featureGroupConfig != null && !featureGroupConfig.isEmpty()) {
                    featureValuesMap = new HashMap<String, Interval>();
                    for (Map.Entry<String, Integer> fgc : featureGroupConfig.entrySet()) {
                        String featureName = new String(fgc.getKey());
                        int groupNum = fgc.getValue();
                        Interval featureIntervalOnOriginalText = null;
                        if (matcher.group(groupNum) != null && matcher.end(groupNum) > matcher.start(groupNum)) {
                            IntervalImpl featureIntervalOnFilteredText = IntervalImpl.createWithCharoffsets(matcher.start(groupNum), matcher.end(groupNum));
                            featureIntervalOnOriginalText = text.convertToUnfilteredPos(featureIntervalOnFilteredText, startPos);
                        }
                        featureValuesMap.put(featureName, featureIntervalOnOriginalText);
                    }
                }
            }
            IntervalImpl intervalOnFilteredText = IntervalImpl.createWithCharoffsets(annotStart, annotEnd);
            Interval intervalOnOriginalText = text.convertToUnfilteredPos(intervalOnFilteredText, 0);
            if (annotEnd > annotStart) {
                if (featureGroupConfig != null) {
                    matchesToAnnotate.add(new MatchInfo(intervalOnOriginalText, featureValuesMap));
                } else {
                    matchesToAnnotate.add(new MatchInfo(intervalOnOriginalText, null));
                }
            }
            pos = annotEnd - startPos;
            featureValuesMap = null;
        }
    }

    protected void matchPatternUsingStackRanging(TCAS aTCAS, FilteredText text, String subText, int startPos, int endPos, TypeEntry.PatternInfo firstScanPatternInfo, TypeEntry.PatternInfo[] patternsInfo, TypeEntry.StackInfo stackInfo, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, List<MatchInfo> matchesToAnnotate) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        ArrayList rangeByStackDepth = new ArrayList();
        Stack<Integer> patternStack = new Stack<Integer>();
        int stackDepth = 0;
        int groupNum = 0;
        int continueSearchPos = 0;
        int rangeStartPos = 0;
        int rangeEndPos = 0;
        int pos = 0;
        ArrayList<MatchInfo> matchesFound = new ArrayList<MatchInfo>();
        Pattern pPushRegex = this.getPattern(aTCAS, stackInfo.getPushPatternPair());
        Pattern pPopRegex = this.getPattern(aTCAS, stackInfo.getPopPatternPair());
        Pattern pBothRegex = this.getPattern(aTCAS, stackInfo.getBothPatternPair());
        boolean eraseRange = stackInfo.getEraseRangeFlag();
        TypeEntry.StackInfo.RangingMethod stackRangingMethod = stackInfo.getRangingMethod();
        Matcher mBothRegex = pBothRegex.matcher(subText);
        Matcher mPushRegex = pPushRegex.matcher(subText);
        Matcher mPopRegex = pPopRegex.matcher(subText);
        while (this.findWithATimeOut(mBothRegex, pos) == FindStatus.MATCH) {
            if (this.findWithATimeOut(mPushRegex, pos) == FindStatus.MATCH && mPushRegex.start() == mBothRegex.start() && mPushRegex.end() == mBothRegex.end()) {
                ++stackDepth;
                int n = groupNum = mPushRegex.groupCount() < 1 ? 0 : 1;
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_Pop || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_PopInclude) {
                    patternStack.push(new Integer(mPushRegex.start(groupNum)));
                }
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_Pop || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_PopInclude) {
                    patternStack.push(new Integer(mPushRegex.end(groupNum)));
                }
                continueSearchPos = mPushRegex.end(groupNum);
                if (eraseRange && stackDepth > 1 && rangeByStackDepth.size() < stackDepth - 1) {
                    rangeByStackDepth.add(stackDepth - 2, new ArrayList());
                }
            } else {
                if (this.findWithATimeOut(mPopRegex, pos) != FindStatus.MATCH || mPopRegex.start() != mBothRegex.start() || mPopRegex.end() != mBothRegex.end()) break;
                if (--stackDepth < 0) {
                    pos = mPopRegex.end();
                    stackDepth = 0;
                    continue;
                }
                rangeStartPos = (Integer)patternStack.pop();
                int n = groupNum = mPopRegex.groupCount() < 1 ? 0 : 1;
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_Pop || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_Pop) {
                    rangeEndPos = mPopRegex.start(groupNum);
                }
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_PopInclude || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_PopInclude) {
                    rangeEndPos = mPopRegex.end(groupNum);
                }
                continueSearchPos = mPopRegex.end(groupNum);
                if (eraseRange && stackDepth > 0) {
                    IntervalImpl curRange = IntervalImpl.createWithCharoffsets(rangeStartPos, rangeEndPos);
                    ((ArrayList)rangeByStackDepth.get(stackDepth - 1)).add(curRange);
                }
                String subSubText = subText.substring(rangeStartPos, rangeEndPos);
                FilteredText newText = new FilteredText(subSubText);
                newText.filter();
                if (eraseRange && rangeByStackDepth.size() > stackDepth) {
                    List upperLevelRanges = (List)rangeByStackDepth.get(stackDepth);
                    for (Interval curRange : upperLevelRanges) {
                        int removeStart = curRange.getStart().getOffset() - rangeStartPos;
                        int removeEnd = curRange.getEnd().getOffset() - rangeStartPos;
                        newText.addInterval(removeStart, removeEnd, "");
                    }
                    newText.filter();
                    subSubText = newText.getFilteredText();
                    rangeByStackDepth.remove(stackDepth);
                }
                int k = 0;
                while (k < patternsInfo.length) {
                    matchesFound.clear();
                    Pattern mainPattern = this.getPattern(aTCAS, patternsInfo[k].getPatternPair());
                    if (firstScanPatternInfo == null) {
                        this.matchPattern(newText, subSubText, 0, subSubText.length(), mainPattern, patternsInfo[k].getTypeGroupNum(), patternsInfo[k].getFeaturesGroupConfig(), matchStartOnly, isAnnotateEntireContainingAnnotation, matchesFound);
                    } else {
                        Pattern firstScanPattern = this.getPattern(aTCAS, firstScanPatternInfo.getPatternPair());
                        this.matchNestedPatterns(newText, subSubText, 0, subSubText.length(), firstScanPattern, firstScanPatternInfo.getTypeGroupNum(), mainPattern, patternsInfo[k].getTypeGroupNum(), patternsInfo[k].getFeaturesGroupConfig(), matchStartOnly, isAnnotateEntireContainingAnnotation, matchesFound);
                    }
                    for (MatchInfo curMatch : matchesFound) {
                        int annotStart = curMatch.getInterval().getStart().getOffset() + rangeStartPos;
                        int annotEnd = curMatch.getInterval().getEnd().getOffset() + rangeStartPos;
                        IntervalImpl intervalOnFilteredText = IntervalImpl.createWithCharoffsets(annotStart, annotEnd);
                        Interval intervalOnOriginalText = text.convertToUnfilteredPos(intervalOnFilteredText, startPos);
                        HashMap<String, Interval> curFeatureValuesMap = curMatch.getFeatureValuesMap();
                        HashMap<String, Interval> convertedFeatureValuesMap = null;
                        if (curFeatureValuesMap != null) {
                            convertedFeatureValuesMap = new HashMap<String, Interval>();
                            for (Map.Entry<String, Interval> featureEntry : curFeatureValuesMap.entrySet()) {
                                String featureName = new String(featureEntry.getKey());
                                Interval featureIntervalOnFilteredText = featureEntry.getValue();
                                Interval featureIntervalOnOriginalText = text.convertToUnfilteredPos(featureIntervalOnFilteredText, startPos + rangeStartPos);
                                convertedFeatureValuesMap.put(featureName, featureIntervalOnOriginalText);
                            }
                        }
                        matchesToAnnotate.add(new MatchInfo(intervalOnOriginalText, convertedFeatureValuesMap));
                    }
                    ++k;
                }
            }
            pos = continueSearchPos;
        }
    }

    protected Pattern getPattern(TCAS aTCAS, TypeEntry.PatternPair patternPair) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        if (patternPair == null) {
            return null;
        }
        if (patternPair.needsDynamicPatternExpansion()) {
            return this.expandPatternWithCasAnnotation(aTCAS, patternPair.getPatternStr());
        }
        return patternPair.getPattern();
    }

    protected Pattern expandPatternWithCasAnnotation(TCAS aTCAS, String patternStr) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        Pattern pCasType = Pattern.compile("(?:\\(\\+\\+)(.+?)(?:\\))");
        String sCasTypeAndFeature = null;
        String sCasType = null;
        String sCasTypeFeature = null;
        Matcher mCasType = pCasType.matcher(patternStr);
        while (mCasType.find()) {
            sCasTypeAndFeature = patternStr.substring(mCasType.start(1), mCasType.end(1));
            int index = (sCasTypeAndFeature = sCasTypeAndFeature.trim()).indexOf(":");
            if (index != -1) {
                sCasTypeFeature = sCasTypeAndFeature.substring(index + 1);
                sCasType = sCasTypeAndFeature.substring(0, index);
            } else {
                sCasType = sCasTypeAndFeature;
            }
            Type tCasType = AnnotatorUtil.nameToCASType(((Object)((Object)this)).getClass().getName(), aTCAS.getTypeSystem(), sCasType, false);
            Feature tCasTypeFeature = tCasType.getFeatureByBaseName(sCasTypeFeature);
            String replacedCasTypePhrase = new StringBuffer().append("(++").append(sCasTypeAndFeature).append(")").toString();
            String AlternationStr = this.typeToAlternationOfAnnotation(aTCAS, tCasType, tCasTypeFeature);
            Pattern checkPattern = Pattern.compile(AlternationStr);
            if (checkPattern.matcher("").matches()) {
                AlternationStr = new String("(?:\\zuu)");
            }
            patternStr = patternStr.replace(replacedCasTypePhrase, AlternationStr);
            mCasType = pCasType.matcher(patternStr);
        }
        Pattern pattern = Pattern.compile(patternStr);
        if (pattern.matcher("").matches()) {
            throw AnnotatorExceptionUtil.getConf("regex matches empty string", patternStr);
        }
        return pattern;
    }

    private String typeToAlternationOfAnnotation(TCAS aTCAS, Type aType, Feature aFeature) {
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        String DocText = aTCAS.getDocumentText();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(aType);
        FSIterator it = idx.iterator();
        HashSet<String> alternationElements = new HashSet<String>();
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            String subText = null;
            subText = aFeature == null ? DocText.substring(fs.getBegin(), fs.getEnd()) : fs.getFeatureValueAsString(aFeature);
            alternationElements.add(subText);
            it.moveToNext();
        }
        HashMap<String, HashSet<String>> optAlternationElements = this.optimizeAlternation(alternationElements);
        StringBuffer res = new StringBuffer();
        res.append("(?:");
        boolean noAltarnationElements = true;
        for (Map.Entry<String, HashSet<String>> optAltElem : optAlternationElements.entrySet()) {
            String key = new String(optAltElem.getKey());
            HashSet<String> vals = optAltElem.getValue();
            key = this.putSlashOnRegeXSpecialChars(key);
            res.append(key).append("(?:");
            for (String valsStr : vals) {
                valsStr = this.putSlashOnRegeXSpecialChars(valsStr);
                res.append(valsStr).append("|");
            }
            res.deleteCharAt(res.length() - 1).append(")|");
            noAltarnationElements = false;
        }
        if (!noAltarnationElements) {
            res.deleteCharAt(res.length() - 1).append(")");
        } else if (noAltarnationElements) {
            res.append(")");
        }
        String resStr = res.toString();
        return resStr;
    }

    private HashMap<String, HashSet<String>> optimizeAlternation(HashSet<String> allStr) {
        HashMap<String, HashSet<String>> chars = new HashMap<String, HashSet<String>>();
        HashSet<Object> allStrRelevantToFirstChar = new HashSet();
        for (String alternationElement : allStr) {
            String firstChar = alternationElement.substring(0, 1);
            String alternationElementMinusFirstChar = alternationElement.substring(1);
            allStrRelevantToFirstChar = chars.get(firstChar);
            if (allStrRelevantToFirstChar == null) {
                allStrRelevantToFirstChar = new HashSet();
            }
            allStrRelevantToFirstChar.add(alternationElementMinusFirstChar);
            chars.put(firstChar, allStrRelevantToFirstChar);
        }
        return chars;
    }

    private String putSlashOnRegeXSpecialChars(String str) {
        str = str.replace("\\", "\\\\");
        str = str.replace("[", "\\[");
        str = str.replace("^", "\\^");
        str = str.replace("{", "\\{");
        str = str.replace("}", "\\}");
        str = str.replace("$", "\\$");
        str = str.replace(".", "\\.");
        str = str.replace("|", "\\|");
        str = str.replace("?", "\\?");
        str = str.replace("*", "\\*");
        str = str.replace("+", "\\+");
        str = str.replace("(", "\\(");
        str = str.replace(")", "\\)");
        return str;
    }

    protected List<MatchInfo> matchPatterns(TCAS aTCAS, FilteredText text, int startPos, int endPos, TypeEntry typeEntry, boolean isAnnotateEntireContainingAnnotation) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        return this.matchPatterns(aTCAS, text, startPos, endPos, typeEntry.mFirstScanPattern, typeEntry.mPatternsInfo, typeEntry.mStackInfo, typeEntry.mStartingCasType != null, isAnnotateEntireContainingAnnotation);
    }

    protected List<MatchInfo> matchPatterns(TCAS aTCAS, FilteredText text, int startPos, int endPos, TypeEntry.PatternInfo firstScanPatternInfo, TypeEntry.PatternInfo[] patternsInfo, TypeEntry.StackInfo stackInfo, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        ArrayList<MatchInfo> matchesToAnnotate = new ArrayList<MatchInfo>();
        String subText = text.getFilteredText().substring(startPos, endPos);
        if (stackInfo != null) {
            this.matchPatternUsingStackRanging(aTCAS, text, subText, startPos, endPos, firstScanPatternInfo, patternsInfo, stackInfo, matchStartOnly, isAnnotateEntireContainingAnnotation, matchesToAnnotate);
        } else if (stackInfo == null) {
            int k = 0;
            while (k < patternsInfo.length) {
                Pattern mainPattern = this.getPattern(aTCAS, patternsInfo[k].getPatternPair());
                if (firstScanPatternInfo == null) {
                    this.matchPattern(text, subText, startPos, endPos, mainPattern, patternsInfo[k].getTypeGroupNum(), patternsInfo[k].getFeaturesGroupConfig(), matchStartOnly, isAnnotateEntireContainingAnnotation, matchesToAnnotate);
                } else {
                    Pattern firstScanPattern = this.getPattern(aTCAS, firstScanPatternInfo.getPatternPair());
                    this.matchNestedPatterns(text, subText, startPos, endPos, firstScanPattern, firstScanPatternInfo.getTypeGroupNum(), mainPattern, patternsInfo[k].getTypeGroupNum(), patternsInfo[k].getFeaturesGroupConfig(), matchStartOnly, isAnnotateEntireContainingAnnotation, matchesToAnnotate);
                }
                ++k;
            }
        }
        this.findExecutionTimer.purge();
        return matchesToAnnotate;
    }

    protected int addAnnotationsToCAS(TCAS aTCAS, List<MatchInfo> matchesToAnnotate, TypeEntry typeEntry, FilteredText text, boolean isCheckIntervals, Intervals intervals) {
        int result = 0;
        for (MatchInfo matchInfo : matchesToAnnotate) {
            Interval interval = matchInfo.getInterval();
            int annotStart = interval.getStart().getOffset();
            int annotEnd = interval.getEnd().getOffset();
            if (isCheckIntervals) {
                if (intervals.checkInterval(interval) == 1) continue;
                intervals.add(interval);
            }
            AnnotationFS fs = aTCAS.createAnnotation(typeEntry.mCasType, annotStart, annotEnd);
            HashMap<String, Interval> featuresValuesMapping = matchInfo.getFeatureValuesMap();
            if (featuresValuesMapping != null) {
                for (Map.Entry<String, Interval> featureEntry : featuresValuesMapping.entrySet()) {
                    String featureName = new String(featureEntry.getKey());
                    Interval featureValue = featureEntry.getValue();
                    String featureValueStr = "";
                    if (featureValue == null) {
                        featureValueStr = "";
                    } else {
                        featureValueStr = text.getText().substring(featureValue.getStart().getOffset(), featureValue.getEnd().getOffset());
                        featureValueStr = featureValueStr.trim();
                    }
                    fs.setFeatureValueFromString(typeEntry.mCasType.getFeatureByBaseName(featureName), featureValueStr);
                }
            }
            aTCAS.getIndexRepository().addFS((FeatureStructure)fs);
            if (typeEntry.mFilterIsAncestorOfType) {
                text.addInterval(annotStart, annotEnd, "");
            }
            ++result;
        }
        return result;
    }

    private FindStatus findWithATimeOut(final Matcher m, int startPos) {
        class TimeOutFlag {
            private volatile boolean timeOutFlag = false;

            public boolean isTimeOut() {
                return this.timeOutFlag;
            }

            public void setTimeOutFlag(boolean flag) {
                this.timeOutFlag = flag;
            }
        }
        final TimeOutFlag objTimeOutFlag = new TimeOutFlag();
        objTimeOutFlag.setTimeOutFlag(false);
        TimerTask ts = new TimerTask(){
            {
            }

            public void run() {
                objTimeOutFlag.setTimeOutFlag(true);
                m.reset("");
            }
        };
        this.findExecutionTimer.schedule(ts, 10000L);
        boolean findRetVal = false;
        boolean boolTimeOutFlag = false;
        try {
            findRetVal = m.find(startPos);
            boolTimeOutFlag = objTimeOutFlag.isTimeOut();
            ts.cancel();
        }
        catch (Exception e) {
            ts.cancel();
            return FindStatus.ERROR;
        }
        if (boolTimeOutFlag) {
            return FindStatus.TIMEOUT;
        }
        if (!findRetVal) {
            return FindStatus.NO_MATCH;
        }
        return FindStatus.MATCH;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FindStatus {
        MATCH,
        NO_MATCH,
        TIMEOUT,
        ERROR;

    }
}

