/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalCombiner {
    private final TreeSet<CombinedInterval> mIntervals = new TreeSet();
    private boolean mUpdated = false;

    public void addInterval(int start, int end) {
        if (end > start) {
            this.mIntervals.add(new CombinedInterval(start, end));
            this.mUpdated = true;
        }
    }

    public void addInterval(int start, int end, String rStr) {
        if (end > start) {
            this.mIntervals.add(new CombinedInterval(start, end, rStr));
            this.mUpdated = true;
        }
    }

    public void addInterval(CombinedInterval interval) {
        if (interval.end > interval.start) {
            this.mIntervals.add(interval);
            this.mUpdated = true;
        }
    }

    public void addInterval(Interval interval) {
        this.addInterval(interval.getStart().getOffset(), interval.getEnd().getOffset());
    }

    public void addAllIntervals(IntervalCombiner other) {
        if (this.mIntervals.addAll(other.mIntervals)) {
            this.mUpdated = true;
        }
    }

    public boolean isEmpty() {
        return this.mIntervals.isEmpty();
    }

    public int size() {
        return this.mIntervals.size();
    }

    public boolean isUptoDate() {
        return !this.mUpdated;
    }

    public void combine() throws AnnotatorConfigurationException {
        if (this.mIntervals.isEmpty() || !this.mUpdated) {
            return;
        }
        Iterator<CombinedInterval> it = this.mIntervals.iterator();
        CombinedInterval prevInterval = it.next();
        while (it.hasNext()) {
            CombinedInterval currInterval = it.next();
            if (prevInterval.contains(currInterval)) {
                if (prevInterval.sameLocation(currInterval) && !prevInterval.getRepresentor().equals(currInterval.getRepresentor())) {
                    prevInterval.representor = "";
                }
                it.remove();
                continue;
            }
            if (prevInterval.overlaps(currInterval)) {
                if (currInterval.getRepresentor().equals(" ")) {
                    prevInterval.representor = " ";
                }
                it.remove();
                prevInterval.end = currInterval.end;
                continue;
            }
            prevInterval = currInterval;
        }
        this.mUpdated = false;
    }

    public Iterator<CombinedInterval> iterator() {
        return this.mIntervals.iterator();
    }

    public ArrayList<CombinedInterval> toArrayList() {
        ArrayList<CombinedInterval> result = new ArrayList<CombinedInterval>();
        result.addAll(this.mIntervals);
        return result;
    }

    public boolean containsInterval(int start, int end) throws AnnotatorConfigurationException {
        return this.containsInterval(start, end, "");
    }

    public boolean containsInterval(int start, int end, String rStr) throws AnnotatorConfigurationException {
        this.combine();
        CombinedInterval interval = new CombinedInterval(start, end, rStr);
        if (this.mIntervals.contains(interval)) {
            return true;
        }
        SortedSet<CombinedInterval> set = this.mIntervals.headSet(interval);
        if (set.isEmpty()) {
            return false;
        }
        CombinedInterval lastInterval = set.last();
        if (lastInterval.sameLocation(interval) && !lastInterval.getRepresentor().equals(interval.getRepresentor())) {
            return false;
        }
        return lastInterval.contains(interval);
    }

    public static class CombinedInterval
    implements Comparable {
        private int start;
        private int end;
        private String representor;

        public CombinedInterval(int start, int end) {
            this.start = start;
            this.end = end;
            this.representor = "";
        }

        public CombinedInterval(int start, int end, String rStr) {
            this.start = start;
            this.end = end;
            this.representor = rStr;
        }

        public boolean sameLocation(CombinedInterval other) {
            return this.start == other.start && other.end == this.end;
        }

        public boolean contains(CombinedInterval other) {
            return this.start <= other.start && other.end <= this.end;
        }

        public boolean overlaps(CombinedInterval other) {
            return this.start < other.end && this.end > other.start;
        }

        public int compareTo(Object o) {
            CombinedInterval other = (CombinedInterval)o;
            if (this.start < other.start) {
                return -1;
            }
            if (this.start > other.start) {
                return 1;
            }
            if (other.end - this.end != 0) {
                return other.end - this.end;
            }
            return this.representor.compareTo(other.representor);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CombinedInterval)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getRepresentor() {
            return this.representor;
        }
    }
}

