/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.IntervalCombiner;
import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.supa.annotator.util.text.location.IntervalImpl;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import java.util.Arrays;
import java.util.Iterator;

public class FilteredText
implements Cloneable {
    private final String mText;
    private IntervalCombiner mIntervals;
    private String mFilteredText;
    private int[] mFilteredOffsets;
    private int[] mAmountFiltered;
    private boolean[] mWhiteSpace;
    private int mFloorPos;
    private boolean mOnAReplacedCharFilteredInterval;
    private boolean mAtTheStartOfTheFilteredInterval;

    public FilteredText(String text) {
        this.mText = text;
        this.mIntervals = new IntervalCombiner();
    }

    public String getText() {
        return this.mText;
    }

    public Object clone() {
        FilteredText result = new FilteredText(this.mText);
        result.mIntervals.addAllIntervals(this.mIntervals);
        result.mFilteredText = this.mFilteredText;
        result.mFilteredOffsets = this.mFilteredOffsets;
        result.mAmountFiltered = this.mAmountFiltered;
        result.mWhiteSpace = this.mWhiteSpace;
        result.mFloorPos = this.mFloorPos;
        result.mOnAReplacedCharFilteredInterval = this.mOnAReplacedCharFilteredInterval;
        result.mAtTheStartOfTheFilteredInterval = this.mAtTheStartOfTheFilteredInterval;
        return result;
    }

    public void addInterval(int start, int end) {
        this.mIntervals.addInterval(start, end);
    }

    public void addInterval(int start, int end, String representor) {
        if (!representor.equals("") && !representor.equals(" ")) {
            throw new IllegalArgumentException("Not an acceptable value " + representor);
        }
        this.mIntervals.addInterval(start, end, representor);
    }

    public boolean containsInterval(int start, int end) throws AnnotatorConfigurationException {
        return this.mIntervals.containsInterval(start, end);
    }

    public boolean containsInterval(int start, int end, String representor) throws AnnotatorConfigurationException {
        if (!representor.equals("") && !representor.equals(" ")) {
            throw new IllegalArgumentException("Not an acceptable value " + representor);
        }
        return this.mIntervals.containsInterval(start, end, representor);
    }

    public void filter() throws AnnotatorConfigurationException {
        if (this.mFilteredOffsets != null && this.mIntervals.isUptoDate()) {
            return;
        }
        if (this.mIntervals.isEmpty()) {
            this.mFilteredText = this.mText;
            this.mFilteredOffsets = null;
            this.mAmountFiltered = null;
            this.mWhiteSpace = null;
            return;
        }
        this.mIntervals.combine();
        this.mFilteredOffsets = new int[this.mIntervals.size()];
        this.mAmountFiltered = new int[this.mIntervals.size() + 1];
        this.mWhiteSpace = new boolean[this.mIntervals.size()];
        int index = 0;
        this.mAmountFiltered[0] = 0;
        StringBuffer sBuf = new StringBuffer();
        int stringIndex = 0;
        Iterator<IntervalCombiner.CombinedInterval> it = this.mIntervals.iterator();
        while (it.hasNext()) {
            IntervalCombiner.CombinedInterval currInterval = it.next();
            int replacedCharLen = currInterval.getRepresentor().length();
            this.mWhiteSpace[index] = replacedCharLen != 0;
            this.mFilteredOffsets[index] = currInterval.getStart() - this.mAmountFiltered[index];
            this.mAmountFiltered[index + 1] = this.mAmountFiltered[index] + currInterval.getEnd() - currInterval.getStart() - replacedCharLen;
            sBuf.append(this.mText.substring(stringIndex, currInterval.getStart()));
            sBuf.append(currInterval.getRepresentor());
            stringIndex = currInterval.getEnd();
            ++index;
        }
        sBuf.append(this.mText.substring(stringIndex, this.mText.length()));
        this.mFilteredText = sBuf.toString();
    }

    public String getFilteredText() {
        return this.mFilteredText;
    }

    public int getUnfilteredPos(int pos) {
        return this.getUnfilteredPos(pos, ReplacedCharUnFilteredPos.At_The_Start);
    }

    public int getUnfilteredPos(int pos, ReplacedCharUnFilteredPos replacedCharFlag) {
        if (pos < 0 || pos > this.mFilteredText.length()) {
            throw new IllegalArgumentException("Index out of range " + pos);
        }
        if (this.isBeforeFirstFilteredInterval(pos)) {
            return pos;
        }
        int index = Arrays.binarySearch(this.mFilteredOffsets, pos);
        index = index < 0 ? -(index + 1) : ++index;
        while (index < this.mFilteredOffsets.length) {
            if (this.mFilteredOffsets[index - 1] != this.mFilteredOffsets[index]) break;
            ++index;
        }
        if (this.mFilteredOffsets[index - 1] == pos && this.mWhiteSpace[index - 1]) {
            if (replacedCharFlag == ReplacedCharUnFilteredPos.At_The_Start) {
                return pos + this.mAmountFiltered[index - 1];
            }
            if (replacedCharFlag == ReplacedCharUnFilteredPos.At_The_End) {
                return pos + this.mAmountFiltered[index];
            }
        }
        return pos + this.mAmountFiltered[index];
    }

    private boolean isBeforeFirstFilteredInterval(int pos) {
        return this.mFilteredOffsets == null || this.mFilteredOffsets.length == 0 || pos < this.mFilteredOffsets[0];
    }

    public int getFilteredPos(int pos) {
        if (pos < 0 || pos > this.mText.length()) {
            throw new IllegalArgumentException("Index out of range " + pos);
        }
        if (this.isBeforeFirstFilteredInterval(pos)) {
            this.mFloorPos = -1;
            this.mOnAReplacedCharFilteredInterval = false;
            this.mAtTheStartOfTheFilteredInterval = false;
            return pos;
        }
        int high = this.mFilteredOffsets.length - 1;
        int low = 0;
        int curIndex = 0;
        while (low <= high) {
            curIndex = (low + high) / 2;
            int locOfFilteredInterval = this.mFilteredOffsets[curIndex] + this.mAmountFiltered[curIndex];
            if (pos < locOfFilteredInterval) {
                high = curIndex - 1;
                if (low <= high) continue;
                --curIndex;
                continue;
            }
            if (pos <= locOfFilteredInterval) break;
            low = curIndex + 1;
        }
        int UnFilteredStartPos = this.mFilteredOffsets[curIndex] + this.mAmountFiltered[curIndex];
        int UnFilteredEndPos = this.mAmountFiltered[curIndex + 1] - this.mAmountFiltered[curIndex] + UnFilteredStartPos;
        if (this.mWhiteSpace[curIndex]) {
            ++UnFilteredEndPos;
        }
        if (pos < UnFilteredEndPos && pos >= UnFilteredStartPos) {
            if (!this.mWhiteSpace[curIndex]) {
                if (UnFilteredStartPos >= 1) {
                    int tempFloor = this.getFilteredPos(UnFilteredStartPos - 1);
                    while (tempFloor == -1) {
                        tempFloor = this.getFilteredPos(this.mFloorPos);
                    }
                    this.mFloorPos = tempFloor;
                } else {
                    this.mFloorPos = -1;
                }
                this.mAtTheStartOfTheFilteredInterval = pos == UnFilteredStartPos;
                this.mOnAReplacedCharFilteredInterval = false;
                return -1;
            }
            this.mFloorPos = -1;
            this.mAtTheStartOfTheFilteredInterval = pos == UnFilteredStartPos;
            this.mOnAReplacedCharFilteredInterval = true;
            return this.mFilteredOffsets[curIndex];
        }
        this.mFloorPos = -1;
        this.mOnAReplacedCharFilteredInterval = false;
        this.mAtTheStartOfTheFilteredInterval = false;
        return pos - this.mAmountFiltered[curIndex + 1];
    }

    public int getFloorPos() {
        return this.mFloorPos;
    }

    public boolean onAReplacedCharFilteredInterval() {
        return this.mOnAReplacedCharFilteredInterval;
    }

    public boolean atTheStartOfTheFilteredInterval() {
        return this.mAtTheStartOfTheFilteredInterval;
    }

    public int getNearestFilteredPos(int pos) {
        int result = this.getFilteredPos(pos);
        if (result == -1) {
            result = this.getFloorPos();
        }
        return result;
    }

    public Interval convertToUnfilteredPos(Interval interval, int offSet) {
        if (interval == null) {
            return null;
        }
        int start = interval.getStart().getOffset();
        int end = interval.getEnd().getOffset();
        IntervalImpl retInterval = IntervalImpl.createWithCharoffsets(this.getUnfilteredPos(offSet + start, ReplacedCharUnFilteredPos.At_The_Start), this.getUnfilteredPos(offSet + end - 1, ReplacedCharUnFilteredPos.At_The_End) + 1);
        return retInterval;
    }

    static final class ReplacedCharUnFilteredPos {
        static final ReplacedCharUnFilteredPos At_The_Start = new ReplacedCharUnFilteredPos();
        static final ReplacedCharUnFilteredPos At_The_End = new ReplacedCharUnFilteredPos();

        private ReplacedCharUnFilteredPos() {
        }
    }
}

