/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.CodeSyntaxAnnotator;
import com.ibm.supa.annotator.annotators.TypeEntry;
import com.ibm.supa.annotator.exception.SUPAConfigException;
import com.ibm.supa.annotator.util.AnnotatorUtil;
import com.ibm.supa.annotator.util.LogUtil;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContextException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import java.io.File;
import java.util.logging.Logger;

public class FileTypeGroupConfig {
    private static Logger sLogger = Logger.getLogger(LogUtil.getLogName(FileTypeGroupConfig.class));
    private TypeEntry[] mTypeEntries;
    private TypeEntry.Factory mTypeEntryFactory;
    private String[] mContainingAnnotationTypeNames;
    private Type[] mContainingAnnotationCASTypes;
    private Boolean mAnnotateEntireContainingAnnotation;
    private Boolean mSkipSubAnnotations;
    private Boolean mCheckIntervals;

    public FileTypeGroupConfig(String pFileType, TypeSystem pTypeSystem, AnnotatorContext pCtx, File pBaseDir) throws AnnotatorConfigurationException {
        try {
            this.mContainingAnnotationTypeNames = (String[])pCtx.getConfigParameterValue(pFileType, "ContainingAnnotationTypes");
            if (this.mContainingAnnotationTypeNames != null && this.mContainingAnnotationTypeNames.length > 0) {
                this.mAnnotateEntireContainingAnnotation = AnnotatorUtil.getBooleanConfigParamValue(pCtx, pFileType, "AnnotateEntireContainingAnnotation");
                this.mSkipSubAnnotations = AnnotatorUtil.getBooleanConfigParamValue(pCtx, pFileType, "SkipSubAnnotations");
            } else {
                this.mAnnotateEntireContainingAnnotation = Boolean.FALSE;
                this.mSkipSubAnnotations = Boolean.FALSE;
            }
            this.initTypeSystem(pTypeSystem, false);
            this.mCheckIntervals = AnnotatorUtil.getBooleanConfigParamValue(pCtx, pFileType, "CheckInclusion");
            this.mTypeEntryFactory = new TypeEntry.Factory(sLogger, pFileType, pTypeSystem, pCtx, pBaseDir);
            this.mTypeEntries = this.mTypeEntryFactory.buildTypeEntries();
        }
        catch (AnnotatorContextException ex) {
            throw new SUPAConfigException("com.ibm.supa.annotator.annotators.AnnotatorMessages", "err_load_config", new Object[]{pFileType}, ex);
        }
        catch (AnnotatorInitializationException ex) {
            throw new SUPAConfigException(ex);
        }
    }

    public void initTypeSystem(TypeSystem pTypeSystem) throws AnnotatorInitializationException {
        this.initTypeSystem(pTypeSystem, true);
    }

    private void initTypeSystem(TypeSystem pTypeSystem, boolean initTypeEntries) throws AnnotatorInitializationException {
        this.mContainingAnnotationCASTypes = AnnotatorUtil.namesToCASTypes(CodeSyntaxAnnotator.class.getName(), pTypeSystem, this.mContainingAnnotationTypeNames, false);
        if (initTypeEntries) {
            this.mTypeEntryFactory.initTypeSystem(pTypeSystem);
            this.mTypeEntries = this.mTypeEntryFactory.buildTypeEntries();
        }
    }

    public boolean isAnnotateEntireContainingAnnotation() {
        return this.mAnnotateEntireContainingAnnotation;
    }

    public boolean isCheckIntervals() {
        return this.mCheckIntervals;
    }

    public Type[] getContainingAnnotationCASTypes() {
        return this.mContainingAnnotationCASTypes;
    }

    public TypeEntry[] getTypeEntries() {
        return this.mTypeEntries;
    }

    public boolean isSkipSubAnnotations() {
        return this.mSkipSubAnnotations;
    }
}

