/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.ConfigurationInfo;
import com.ibm.supa.annotator.annotators.DefaultConfigurationInfo;
import com.ibm.supa.annotator.annotators.FileTypeGroupConfig;
import com.ibm.supa.annotator.annotators.FilteredText;
import com.ibm.supa.annotator.annotators.IntervalCombiner;
import com.ibm.supa.annotator.annotators.MatchInfo;
import com.ibm.supa.annotator.annotators.SupaBaseAnnotator;
import com.ibm.supa.annotator.annotators.TypeEntry;
import com.ibm.supa.annotator.util.intervals.Intervals;
import com.ibm.supa.annotator.util.intervals.IntervalsImpl;
import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.analysis_engine.annotator.TextAnnotator;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.text.TCAS;
import java.util.ArrayList;
import java.util.List;

public class CodeSyntaxAnnotator
extends SupaBaseAnnotator
implements TextAnnotator {
    public CodeSyntaxAnnotator() {
        this(DefaultConfigurationInfo.INSTANCE);
    }

    protected CodeSyntaxAnnotator(ConfigurationInfo configInfo) {
        super(configInfo);
    }

    protected void subProcess(TCAS aTCAS, ResultSpecification aResultSpec, FileTypeGroupConfig cfg) throws AnnotatorProcessException {
        try {
            TypeEntry[] typeEntries = cfg.getTypeEntries();
            TypeSystem typeSystem = aTCAS.getTypeSystem();
            List<Type> resultTypes = this.createResultTypes(aResultSpec, typeSystem);
            IntervalsImpl intervals = new IntervalsImpl();
            int j = 0;
            while (j < typeEntries.length) {
                if (this.resultIncludesType(typeSystem, resultTypes, typeEntries[j].mCasType)) {
                    boolean annotationsAdded;
                    List<Interval> ranges = this.getRangesToAnnotate(typeEntries[j], cfg.getContainingAnnotationCASTypes(), cfg.isSkipSubAnnotations(), aTCAS);
                    boolean repeatForAllIntervals = true;
                    if (typeEntries[j].mRunTillNoAnnotationsAdded) {
                        IntervalCombiner combiner = new IntervalCombiner();
                        for (Interval range : ranges) {
                            combiner.addInterval(range);
                        }
                        combiner.combine();
                        repeatForAllIntervals = combiner.size() < ranges.size();
                    }
                    FilteredText text = this.getFilteredText(typeEntries[j], aTCAS);
                    do {
                        text.filter();
                        ArrayList<Interval> nextRanges = null;
                        annotationsAdded = false;
                        for (Interval range : ranges) {
                            int endPos;
                            int startPos = range.getStart().getOffset();
                            if (this.matchPatterns(aTCAS, cfg, intervals, text, startPos, endPos = range.getEnd().getOffset(), typeEntries[j]) <= 0) continue;
                            annotationsAdded = true;
                            if (!typeEntries[j].mRunTillNoAnnotationsAdded || repeatForAllIntervals) continue;
                            if (nextRanges == null) {
                                nextRanges = new ArrayList<Interval>();
                            }
                            nextRanges.add(range);
                        }
                        if (repeatForAllIntervals) continue;
                        ranges = nextRanges;
                    } while (typeEntries[j].mRunTillNoAnnotationsAdded && annotationsAdded);
                    if (typeEntries[j].mSaveFilteredTextName != null) {
                        this.saveFilteredTextInstance(typeEntries[j], text);
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException((Throwable)e);
        }
    }

    private int matchPatterns(TCAS aTCAS, FileTypeGroupConfig cfg, Intervals intervals, FilteredText text, int startPos, int endPos, TypeEntry typeEntry) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        boolean isAnnotateEntireContainingAnnotation = cfg.isAnnotateEntireContainingAnnotation();
        boolean isCheckIntervals = cfg.isCheckIntervals();
        if (text.getFilteredText().length() == 0) {
            return 0;
        }
        if ((startPos = text.getFilteredPos(startPos)) == -1) {
            if (typeEntry.mStartingCasType != null) {
                return 0;
            }
            startPos = text.getFloorPos() + 1;
        } else if (text.onAReplacedCharFilteredInterval() && !text.atTheStartOfTheFilteredInterval()) {
            if (typeEntry.mStartingCasType != null) {
                return 0;
            }
            ++startPos;
        }
        endPos = text.getFilteredPos(endPos);
        if (endPos == -1) {
            endPos = text.getFloorPos() + 1;
        }
        if (startPos >= endPos) {
            return 0;
        }
        List<MatchInfo> matchesToAnnotate = this.matchPatterns(aTCAS, text, startPos, endPos, typeEntry, isAnnotateEntireContainingAnnotation);
        matchesToAnnotate = this.getLimittedRanges(matchesToAnnotate, typeEntry.mLimittingCasTypes, true, aTCAS);
        return this.addAnnotationsToCAS(aTCAS, matchesToAnnotate, typeEntry, text, isCheckIntervals, intervals);
    }
}

