/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

public class TermExtSpans
extends IterableExtSpans {
    protected TermPositions positions;
    protected Term term;
    protected int doc;
    protected int freq;
    protected int count;
    protected int position;
    private ExtSpanQuery query;

    public TermExtSpans(ExtSpanQuery query, IndexReader reader, Term term) throws IOException {
        super(reader);
        this.query = query;
        this.positions = reader.termPositions(term);
        this.term = term;
        this.doc = -1;
    }

    public boolean next() throws IOException {
        if (this.count == this.freq) {
            if (!this.positions.next()) {
                this.doc = Integer.MAX_VALUE;
                return false;
            }
            this.doc = this.positions.doc();
            this.freq = this.positions.freq();
            this.count = 0;
        }
        this.position = this.positions.nextPosition();
        ++this.count;
        return true;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.doc >= target) {
            return this.next();
        }
        if (!this.positions.skipTo(target)) {
            this.doc = Integer.MAX_VALUE;
            return false;
        }
        this.doc = this.positions.doc();
        this.freq = this.positions.freq();
        this.count = 0;
        this.position = this.positions.nextPosition();
        ++this.count;
        return true;
    }

    public int doc() {
        return this.doc;
    }

    public int start() {
        return this.position;
    }

    public int end() {
        return this.position + 1;
    }

    public String toString() {
        return "spans(" + this.term.toString() + ")@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : this.doc + "-" + this.position));
    }

    public TermPositions getPositions() {
        return this.positions;
    }

    public int numSubExtSpans() {
        return 0;
    }

    public ExtSpans subExtSpan(int index) {
        return null;
    }

    public ExtSpanQuery query() {
        return this.query;
    }
}

