/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.NonIterableExtSpans;

public class SingleExtSpans
extends NonIterableExtSpans {
    private final int doc;
    private final int start;
    private final int end;
    private final ExtSpanQuery query;
    private final ExtSpans[] subSpans;

    public SingleExtSpans(ExtSpans extSpans) {
        super(extSpans.reader());
        this.doc = extSpans.doc();
        this.start = extSpans.start();
        this.end = extSpans.end();
        this.query = extSpans.query();
        this.subSpans = new ExtSpans[extSpans.numSubExtSpans()];
        for (int i = 0; i < this.subSpans.length; ++i) {
            this.subSpans[i] = extSpans.subExtSpan(i).nonIterableCopy(true);
        }
    }

    public int numSubExtSpans() {
        return this.subSpans.length;
    }

    public ExtSpanQuery query() {
        return this.query;
    }

    public ExtSpans subExtSpan(int index) {
        return this.subSpans[index];
    }

    public int doc() {
        return this.doc;
    }

    public int end() {
        return this.end;
    }

    public int start() {
        return this.start;
    }
}

