/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanNearQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;
import org.apache.lucene.search.spans.extended.NearExtSpansOrdered;
import org.apache.lucene.util.PriorityQueue;

class NearExtSpansUnordered
extends IterableExtSpans {
    private ExtSpanNearQuery query;
    private List ordered = new ArrayList();
    private int slop;
    private ExtSpansCell first;
    private ExtSpansCell last;
    private int totalLength;
    private CellQueue queue;
    private ExtSpansCell max;
    private boolean more = true;
    private boolean firstTime = true;

    public NearExtSpansUnordered(ExtSpanNearQuery query, IndexReader reader) throws IOException {
        super(reader);
        this.query = query;
        this.slop = query.getSlop();
        ExtSpanQuery[] clauses = query.getClauses();
        this.queue = new CellQueue(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            ExtSpansCell cell = new ExtSpansCell(clauses[i].getExtSpans(reader), i);
            this.ordered.add(cell);
        }
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.initList(true);
            this.listToQueue();
            this.firstTime = false;
        } else if (this.more) {
            if (this.min().next()) {
                this.queue.adjustTop();
            } else {
                this.more = false;
            }
        }
        while (this.more) {
            boolean queueStale = false;
            if (this.min().doc() != this.max.doc()) {
                this.queueToList();
                queueStale = true;
            }
            while (this.more && this.first.doc() < this.last.doc()) {
                this.more = this.first.skipTo(this.last.doc());
                this.firstToLast();
                queueStale = true;
            }
            if (!this.more) {
                return false;
            }
            if (queueStale) {
                this.listToQueue();
                queueStale = false;
            }
            if (this.atMatch()) {
                return true;
            }
            this.more = this.min().next();
            if (!this.more) continue;
            this.queue.adjustTop();
        }
        return false;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.initList(false);
            ExtSpansCell cell = this.first;
            while (this.more && cell != null) {
                this.more = cell.skipTo(target);
                cell = cell.next;
            }
            if (this.more) {
                this.listToQueue();
            }
            this.firstTime = false;
        } else {
            while (this.more && this.min().doc() < target) {
                if (this.min().skipTo(target)) {
                    this.queue.adjustTop();
                    continue;
                }
                this.more = false;
            }
        }
        return this.more && (this.atMatch() || this.next());
    }

    private ExtSpansCell min() {
        return (ExtSpansCell)this.queue.top();
    }

    public int doc() {
        return this.min().doc();
    }

    public int start() {
        return this.min().start();
    }

    public int end() {
        return this.max.end();
    }

    public int numSubExtSpans() {
        return this.ordered.size();
    }

    public ExtSpans subExtSpan(int index) {
        return (ExtSpans)this.ordered.get(index);
    }

    public ExtSpanQuery query() {
        return this.query;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }

    private void initList(boolean next) throws IOException {
        for (int i = 0; this.more && i < this.ordered.size(); ++i) {
            ExtSpansCell cell = (ExtSpansCell)this.ordered.get(i);
            if (next) {
                this.more = cell.next();
            }
            if (!this.more) continue;
            this.addToList(cell);
        }
    }

    private void addToList(ExtSpansCell cell) {
        if (this.last != null) {
            this.last.next = cell;
        } else {
            this.first = cell;
        }
        this.last = cell;
        cell.next = null;
    }

    private void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    private void queueToList() {
        this.first = null;
        this.last = null;
        while (this.queue.top() != null) {
            this.addToList((ExtSpansCell)this.queue.pop());
        }
    }

    private void listToQueue() {
        this.queue.clear();
        ExtSpansCell cell = this.first;
        while (cell != null) {
            this.queue.put(cell);
            cell = cell.next;
        }
    }

    private boolean atMatch() {
        return this.min().doc() == this.max.doc() && this.max.end() - this.min().start() - this.totalLength <= this.slop;
    }

    private class ExtSpansCell
    extends IterableExtSpans {
        private ExtSpans extSpans;
        private ExtSpansCell next;
        private int length;
        private int index;

        public ExtSpansCell(ExtSpans spans, int index) {
            super(spans.reader());
            this.length = -1;
            this.extSpans = spans;
            this.index = index;
        }

        public boolean next() throws IOException {
            return this.adjust(this.extSpans.next());
        }

        public boolean skipTo(int target) throws IOException {
            return this.adjust(this.extSpans.skipTo(target));
        }

        private boolean adjust(boolean condition) {
            if (this.length != -1) {
                NearExtSpansUnordered.this.totalLength -= this.length;
            }
            if (condition) {
                this.length = this.end() - this.start();
                NearExtSpansUnordered.this.totalLength += this.length;
                if (NearExtSpansUnordered.this.max == null || this.doc() > NearExtSpansUnordered.this.max.doc() || this.doc() == NearExtSpansUnordered.this.max.doc() && this.end() > NearExtSpansUnordered.this.max.end()) {
                    NearExtSpansUnordered.this.max = this;
                }
            }
            NearExtSpansUnordered.this.more = condition;
            return condition;
        }

        public int doc() {
            return this.extSpans.doc();
        }

        public int start() {
            return this.extSpans.start();
        }

        public int end() {
            return this.extSpans.end();
        }

        public int numSubExtSpans() {
            return this.extSpans.numSubExtSpans();
        }

        public ExtSpans subExtSpan(int index) {
            return this.extSpans.subExtSpan(index);
        }

        public ExtSpanQuery query() {
            return this.extSpans.query();
        }

        public String toString() {
            return this.extSpans.toString() + "#" + this.index;
        }
    }

    private class CellQueue
    extends PriorityQueue {
        public CellQueue(int size) {
            this.initialize(size);
        }

        protected final boolean lessThan(Object o1, Object o2) {
            ExtSpansCell spans1 = (ExtSpansCell)o1;
            ExtSpansCell spans2 = (ExtSpansCell)o2;
            if (spans1.doc() == spans2.doc()) {
                return NearExtSpansOrdered.docSpansOrdered(spans1, spans2);
            }
            return spans1.doc() < spans2.doc();
        }
    }
}

