/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.util.BloomFilter;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.es.nuvo.util.Vlong8;
import java.util.logging.Level;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpansFilter;

public class ExtSpansDocHashFilter
implements ExtSpansFilter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean dupsRemoved = false;
    private IndexReader reader;
    private BloomFilter bloomFilter;
    private TermPositions tpos;
    private String exceptionMessageArgument;

    public String getExceptionMessageArgument() {
        return this.exceptionMessageArgument;
    }

    public void setExceptionMessageArgument(String exceptionMessageArgument) {
        this.exceptionMessageArgument = exceptionMessageArgument;
    }

    public ExtSpansFilter clone() {
        return new ExtSpansDocHashFilter();
    }

    public boolean accept(ExtSpans extSpans) {
        block7: {
            try {
                if (this.reader == null || this.reader != extSpans.reader()) {
                    this.reader = extSpans.reader();
                    this.tpos = this.reader.termPositions(new Term("_dochash", "_dochash"));
                    int size = (int)Math.ceil(BloomFilter.getRequiredSize(this.reader.numDocs(), 4, 1.0E-6) / 32.0);
                    this.bloomFilter = new BloomFilter(size, 4);
                }
                int doc = extSpans.doc();
                if (this.tpos.doc() < doc && !this.tpos.skipTo(doc)) {
                    return true;
                }
                if (this.tpos.doc() != doc) {
                    return true;
                }
                byte[] docHash = new byte[this.tpos.getPayloadLength()];
                if (docHash != null && docHash.length > 0) {
                    this.tpos.getPayload(docHash, 0);
                    long hash = Vlong8.decode(docHash, new Vint8.Position(1));
                    boolean removed = this.bloomFilter.add(hash);
                    this.dupsRemoved |= removed;
                    return !removed;
                }
            }
            catch (Exception e) {
                Message msg = new Message("S0210W.DOCHASH_INIT_FAILURE");
                msg.addArgument(this.reader.directory().toString());
                if (this.exceptionMessageArgument != null) {
                    msg.addArgument(this.exceptionMessageArgument);
                }
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                if (!Loggers.logger.isLoggable(Level.WARNING)) break block7;
                Loggers.logger.log(exc);
            }
        }
        return true;
    }

    public boolean dupsRemoved() {
        return this.dupsRemoved;
    }
}

