/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.TermExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanTermQuery
extends ExtSpanQuery {
    protected Term term;

    public ExtSpanTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public String getField() {
        return this.term.field();
    }

    public Collection getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.term);
        return terms;
    }

    public void extractTerms(Set terms) {
        terms.add(this.term);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (this.term.field().equals(field)) {
            buffer.append(this.term.text());
        } else {
            buffer.append(this.term.toString());
        }
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExtSpanTermQuery)) {
            return false;
        }
        ExtSpanTermQuery other = (ExtSpanTermQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.term.equals((Object)other.term);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.term.hashCode() ^ 0xD23FE494;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        return new TermExtSpans(this, reader, this.term);
    }

    public ExtSpanQuery includedClause(int i) {
        return null;
    }

    public int numIncludedClauses() {
        return 0;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        return this;
    }
}

