/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.extended.DelegatedExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanOrQuery
extends ExtSpanQuery {
    private List clauses;
    private String field;

    public ExtSpanOrQuery(ExtSpanQuery[] clauses) {
        this.clauses = new ArrayList(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            ExtSpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
    }

    public ExtSpanQuery[] getClauses() {
        return this.clauses.toArray(new ExtSpanQuery[this.clauses.size()]);
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        for (ExtSpanQuery clause : this.clauses) {
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public void extractTerms(Set terms) {
        for (ExtSpanQuery clause : this.clauses) {
            clause.extractTerms(terms);
        }
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanQuery result = this;
        if (this.clauses.size() == 1) {
            result = (ExtSpanQuery)((Object)this.clauses.get(0));
            if (recurseToClauses) {
                result = result.optimize(true);
            }
        } else if (recurseToClauses) {
            ExtSpanOrQuery clone = this;
            for (int i = 0; i < this.clauses.size(); ++i) {
                ExtSpanQuery clause = (ExtSpanQuery)((Object)this.clauses.get(i));
                ExtSpanQuery optimized = clause.optimize(true);
                if (optimized == clause) continue;
                if (clone == this) {
                    clone = (ExtSpanOrQuery)((Object)this.clone());
                }
                clone.clauses.set(i, optimized);
            }
            result = clone;
        }
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ExtSpanOrQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            ExtSpanQuery c = (ExtSpanQuery)((Object)this.clauses.get(i));
            ExtSpanQuery query = (ExtSpanQuery)c.rewrite(reader);
            if (query == c) continue;
            if (clone == null) {
                clone = (ExtSpanOrQuery)((Object)this.clone());
            }
            clone.clauses.set(i, query);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanOr([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            ExtSpanQuery clause = (ExtSpanQuery)((Object)i.next());
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("])");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExtSpanOrQuery that = (ExtSpanOrQuery)((Object)o);
        if (!((Object)this.clauses).equals(that.clauses)) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int h = ((Object)this.clauses).hashCode();
        h ^= h << 10 | h >>> 23;
        return h ^= Float.floatToRawIntBits(this.getBoost());
    }

    public ExtSpans getExtSpans(final IndexReader reader) throws IOException {
        if (this.clauses.size() == 1) {
            return new DelegatedExtSpans(((ExtSpanQuery)((Object)this.clauses.get(0))).getExtSpans(reader), this);
        }
        return new IterableExtSpans(reader){
            private ExtSpanQueue queue;
            {
                super(x0);
                this.queue = null;
            }

            private boolean initSpanQueue(int target) throws IOException {
                this.queue = new ExtSpanQueue(ExtSpanOrQuery.this.clauses.size());
                Iterator i = ExtSpanOrQuery.this.clauses.iterator();
                while (i.hasNext()) {
                    ExtSpans spans = ((ExtSpanQuery)((Object)i.next())).getExtSpans(reader);
                    if ((target != -1 || !spans.next()) && (target == -1 || !spans.skipTo(target))) continue;
                    this.queue.put(spans);
                }
                return this.queue.size() != 0;
            }

            public boolean next() throws IOException {
                if (this.queue == null) {
                    return this.initSpanQueue(-1);
                }
                if (this.queue.size() == 0) {
                    return false;
                }
                if (this.top().next()) {
                    this.queue.adjustTop();
                    return true;
                }
                this.queue.pop();
                return this.queue.size() != 0;
            }

            private ExtSpans top() {
                return (ExtSpans)this.queue.top();
            }

            public boolean skipTo(int target) throws IOException {
                if (this.queue == null) {
                    return this.initSpanQueue(target);
                }
                boolean skipCalled = false;
                while (this.queue.size() != 0 && this.top().doc() < target) {
                    if (this.top().skipTo(target)) {
                        this.queue.adjustTop();
                    } else {
                        this.queue.pop();
                    }
                    skipCalled = true;
                }
                if (skipCalled) {
                    return this.queue.size() != 0;
                }
                return this.next();
            }

            public int doc() {
                return this.top().doc();
            }

            public int start() {
                return this.top().start();
            }

            public int end() {
                return this.top().end();
            }

            public int numSubExtSpans() {
                return 1;
            }

            public ExtSpans subExtSpan(int index) {
                return this.top();
            }

            public ExtSpanQuery query() {
                return ExtSpanOrQuery.this;
            }

            public String toString() {
                return "spans(" + (Object)((Object)ExtSpanOrQuery.this) + ")@" + (this.queue == null ? "START" : (this.queue.size() > 0 ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
            }
        };
    }

    public ExtSpanQuery includedClause(int i) {
        return (ExtSpanQuery)((Object)this.clauses.get(i));
    }

    public int numIncludedClauses() {
        return this.clauses.size();
    }

    private class ExtSpanQueue
    extends PriorityQueue {
        public ExtSpanQueue(int size) {
            this.initialize(size);
        }

        protected final boolean lessThan(Object o1, Object o2) {
            ExtSpans spans1 = (ExtSpans)o1;
            ExtSpans spans2 = (ExtSpans)o2;
            if (spans1.doc() == spans2.doc()) {
                if (spans1.start() == spans2.start()) {
                    return spans1.end() < spans2.end();
                }
                return spans1.start() < spans2.start();
            }
            return spans1.doc() < spans2.doc();
        }
    }
}

