/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.extended.DelegatedExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanOrQuery;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.NearExtSpansOrdered;
import org.apache.lucene.search.spans.extended.NearExtSpansUnordered;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanNearQuery
extends ExtSpanQuery {
    private List clauses;
    private int slop;
    private boolean inOrder;
    private String field;

    public ExtSpanNearQuery(ExtSpanQuery[] clauses, int slop, boolean inOrder) {
        this.clauses = new ArrayList(clauses.length);
        for (int i = 0; i < clauses.length; ++i) {
            ExtSpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public ExtSpanQuery[] getClauses() {
        return this.clauses.toArray(new ExtSpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        for (ExtSpanQuery clause : this.clauses) {
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public void extractTerms(Set terms) {
        for (ExtSpanQuery clause : this.clauses) {
            clause.extractTerms(terms);
        }
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanNear([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            ExtSpanQuery clause = (ExtSpanQuery)((Object)i.next());
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        if (this.clauses.size() == 0) {
            return new DelegatedExtSpans(new ExtSpanOrQuery(this.getClauses()).getExtSpans(reader), this);
        }
        if (this.clauses.size() == 1) {
            return new DelegatedExtSpans(((ExtSpanQuery)((Object)this.clauses.get(0))).getExtSpans(reader), this);
        }
        return this.inOrder ? new NearExtSpansOrdered(this, reader) : new NearExtSpansUnordered(this, reader);
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanQuery result = this;
        if (this.clauses.size() == 0) {
            result = new ExtSpanOrQuery(this.getClauses());
        } else if (this.clauses.size() == 1) {
            result = (ExtSpanQuery)((Object)this.clauses.get(0));
            if (recurseToClauses) {
                result = result.optimize(true);
            }
        } else if (recurseToClauses) {
            ExtSpanNearQuery clone = this;
            for (int i = 0; i < this.clauses.size(); ++i) {
                ExtSpanQuery clause = (ExtSpanQuery)((Object)this.clauses.get(i));
                ExtSpanQuery optimized = clause.optimize(true);
                if (optimized == clause) continue;
                if (clone == this) {
                    clone = (ExtSpanNearQuery)((Object)this.clone());
                }
                clone.clauses.set(i, optimized);
            }
            result = clone;
        }
        return result;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ExtSpanNearQuery clone = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            ExtSpanQuery c = (ExtSpanQuery)((Object)this.clauses.get(i));
            ExtSpanQuery query = (ExtSpanQuery)c.rewrite(reader);
            if (query == c) continue;
            if (clone == null) {
                clone = (ExtSpanNearQuery)((Object)this.clone());
            }
            clone.clauses.set(i, query);
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public ExtSpanQuery includedClause(int i) {
        return (ExtSpanQuery)((Object)this.clauses.get(i));
    }

    public int numIncludedClauses() {
        return this.clauses.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtSpanNearQuery)) {
            return false;
        }
        ExtSpanNearQuery spanNearQuery = (ExtSpanNearQuery)((Object)o);
        if (this.inOrder != spanNearQuery.inOrder) {
            return false;
        }
        if (this.slop != spanNearQuery.slop) {
            return false;
        }
        if (!((Object)this.clauses).equals(spanNearQuery.clauses)) {
            return false;
        }
        return this.getBoost() == spanNearQuery.getBoost();
    }

    public int hashCode() {
        int result = ((Object)this.clauses).hashCode();
        result ^= result << 14 | result >>> 19;
        result += Float.floatToRawIntBits(this.getBoost());
        result += this.slop;
        return result ^= this.inOrder ? -1716530243 : 0;
    }
}

