/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanFirstQuery
extends ExtSpanQuery {
    private ExtSpanQuery match;
    private int end;

    public ExtSpanFirstQuery(ExtSpanQuery match, int end) {
        this.match = match;
        this.end = end;
    }

    public ExtSpanQuery getMatch() {
        return this.match;
    }

    public int getEnd() {
        return this.end;
    }

    public String getField() {
        return this.match.getField();
    }

    public Collection getTerms() {
        return this.match.getTerms();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanFirst(");
        buffer.append(this.match.toString(field));
        buffer.append(", ");
        buffer.append(this.end);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public void extractTerms(Set terms) {
        this.match.extractTerms(terms);
    }

    public ExtSpans getExtSpans(final IndexReader reader) throws IOException {
        return new IterableExtSpans(reader){
            private ExtSpans extSpans;
            {
                super(x0);
                this.extSpans = ExtSpanFirstQuery.this.match.getExtSpans(reader);
            }

            public boolean next() throws IOException {
                while (this.extSpans.next()) {
                    if (this.end() > ExtSpanFirstQuery.this.end) continue;
                    return true;
                }
                return false;
            }

            public boolean skipTo(int target) throws IOException {
                if (!this.extSpans.skipTo(target)) {
                    return false;
                }
                if (this.extSpans.end() <= ExtSpanFirstQuery.this.end) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.extSpans.doc();
            }

            public int start() {
                return this.extSpans.start();
            }

            public int end() {
                return this.extSpans.end();
            }

            public int numSubExtSpans() {
                return 1;
            }

            public ExtSpans subExtSpan(int index) {
                return this.extSpans;
            }

            public ExtSpanQuery query() {
                return ExtSpanFirstQuery.this;
            }

            public String toString() {
                return "spans(" + ExtSpanFirstQuery.this.toString() + ")";
            }
        };
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ExtSpanFirstQuery clone = null;
        ExtSpanQuery rewritten = (ExtSpanQuery)this.match.rewrite(reader);
        if (rewritten != this.match) {
            clone = (ExtSpanFirstQuery)((Object)this.clone());
            clone.match = rewritten;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public ExtSpanQuery includedClause(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.match;
    }

    public int numIncludedClauses() {
        return 1;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        if (!recurseToClauses) {
            return this;
        }
        ExtSpanFirstQuery result = this;
        ExtSpanQuery optMatch = this.match.optimize(true);
        if (optMatch != this.match) {
            result = new ExtSpanFirstQuery(optMatch, this.end);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtSpanFirstQuery)) {
            return false;
        }
        ExtSpanFirstQuery other = (ExtSpanFirstQuery)((Object)o);
        return this.end == other.end && this.match.equals((Object)other.match) && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = this.match.hashCode();
        h ^= h << 8 | h >>> 25;
        return h ^= Float.floatToRawIntBits(this.getBoost()) ^ this.end;
    }
}

