/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanFarQuery
extends ExtSpanQuery {
    private ExtSpanQuery include;
    private ExtSpanQuery exclude;
    private int minSlopBefore;
    private int minSlopAfter;

    public ExtSpanFarQuery(ExtSpanQuery include, ExtSpanQuery exclude, int slop) {
        this(include, exclude, slop, slop);
    }

    public ExtSpanFarQuery(ExtSpanQuery include, ExtSpanQuery exclude, int minSlopBefore, int minSlopAfter) {
        this.include = include;
        this.exclude = exclude;
        this.minSlopBefore = minSlopBefore;
        this.minSlopAfter = minSlopAfter;
        if (!include.getField().equals(exclude.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public ExtSpanQuery getInclude() {
        return this.include;
    }

    public ExtSpanQuery getExclude() {
        return this.exclude;
    }

    public String getField() {
        return this.include.getField();
    }

    public Collection getTerms() {
        return this.include.getTerms();
    }

    public void extractTerms(Set terms) {
        this.include.extractTerms(terms);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("extSpanFar(");
        buffer.append(this.include.toString(field));
        buffer.append(", ");
        buffer.append(this.exclude.toString(field));
        buffer.append(" {");
        buffer.append(this.minSlopBefore);
        buffer.append(", ");
        buffer.append(this.minSlopAfter);
        buffer.append("})");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public ExtSpans getExtSpans(final IndexReader reader) throws IOException {
        return new IterableExtSpans(reader){
            private ExtSpans includeExtSpans;
            private boolean moreInclude;
            private ExtSpans excludeExtSpans;
            private boolean moreExclude;
            {
                super(x0);
                this.includeExtSpans = ExtSpanFarQuery.this.include.getExtSpans(reader);
                this.moreInclude = true;
                this.excludeExtSpans = ExtSpanFarQuery.this.exclude.getExtSpans(reader);
                this.moreExclude = this.excludeExtSpans.next();
            }

            public boolean next() throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeExtSpans.next();
                }
                while (this.moreInclude && this.moreExclude) {
                    if (this.includeExtSpans.doc() > this.excludeExtSpans.doc()) {
                        this.moreExclude = this.excludeExtSpans.skipTo(this.includeExtSpans.doc());
                    }
                    this.moveExclude();
                    if (this.atMatch()) break;
                    this.moreInclude = this.includeExtSpans.next();
                }
                return this.moreInclude;
            }

            private boolean atMatch() {
                return !this.moreExclude || this.includeExtSpans.doc() != this.excludeExtSpans.doc() || this.includeExtSpans.end() + ExtSpanFarQuery.this.minSlopAfter <= this.excludeExtSpans.start();
            }

            private void moveExclude() throws IOException {
                while (this.moreExclude && this.includeExtSpans.doc() == this.excludeExtSpans.doc() && this.excludeExtSpans.end() + ExtSpanFarQuery.this.minSlopBefore <= this.includeExtSpans.start()) {
                    this.moreExclude = this.excludeExtSpans.next();
                }
            }

            public boolean skipTo(int target) throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeExtSpans.skipTo(target);
                }
                if (!this.moreInclude) {
                    return false;
                }
                if (this.moreExclude && this.includeExtSpans.doc() > this.excludeExtSpans.doc()) {
                    this.moreExclude = this.excludeExtSpans.skipTo(this.includeExtSpans.doc());
                }
                this.moveExclude();
                if (this.atMatch()) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.includeExtSpans.doc();
            }

            public int start() {
                return this.includeExtSpans.start();
            }

            public int end() {
                return this.includeExtSpans.end();
            }

            public int numSubExtSpans() {
                return 1;
            }

            public ExtSpans subExtSpan(int index) {
                return this.includeExtSpans;
            }

            public ExtSpanQuery query() {
                return ExtSpanFarQuery.this;
            }

            public String toString() {
                return "spans(" + ExtSpanFarQuery.this.toString() + ")";
            }
        };
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ExtSpanQuery rewrittenExclude;
        ExtSpanFarQuery clone = null;
        ExtSpanQuery rewrittenInclude = (ExtSpanQuery)this.include.rewrite(reader);
        if (rewrittenInclude != this.include) {
            clone = (ExtSpanFarQuery)((Object)this.clone());
            clone.include = rewrittenInclude;
        }
        if ((rewrittenExclude = (ExtSpanQuery)this.exclude.rewrite(reader)) != this.exclude) {
            if (clone == null) {
                clone = (ExtSpanFarQuery)((Object)this.clone());
            }
            clone.exclude = rewrittenExclude;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public ExtSpanQuery includedClause(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.include;
    }

    public int numIncludedClauses() {
        return 1;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        ExtSpanQuery optimizedExclude;
        if (!recurseToClauses) {
            return this;
        }
        ExtSpanFarQuery clone = null;
        ExtSpanQuery optimizedInclude = this.include.optimize(true);
        if (optimizedInclude != this.include) {
            clone = (ExtSpanFarQuery)((Object)this.clone());
            clone.include = optimizedInclude;
        }
        if ((optimizedExclude = this.exclude.optimize(true)) != this.exclude) {
            if (clone == null) {
                clone = (ExtSpanFarQuery)((Object)this.clone());
            }
            clone.exclude = optimizedExclude;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtSpanFarQuery)) {
            return false;
        }
        ExtSpanFarQuery other = (ExtSpanFarQuery)((Object)o);
        return this.include.equals((Object)other.include) && this.exclude.equals((Object)other.exclude) && this.minSlopBefore == other.minSlopBefore && this.minSlopAfter == other.minSlopAfter && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = this.include.hashCode();
        h = h << 1 | h >>> 31;
        h ^= this.exclude.hashCode();
        h = h << 1 | h >>> 31;
        h ^= Float.floatToRawIntBits(this.getBoost());
        h += this.minSlopBefore;
        return h += this.minSlopAfter;
    }
}

