/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.spans.extended.BitSetExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanDocQuery
extends ExtSpanQuery {
    private final Query docQuery;
    private final boolean inclusive;
    private String field;

    public ExtSpanDocQuery(Query docQuery, boolean inclusive) {
        this(docQuery, inclusive, null);
    }

    public ExtSpanDocQuery(Query docQuery, boolean inclusive, String field) {
        this.docQuery = docQuery;
        this.inclusive = inclusive;
        this.field = field;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        BitSet bits = new QueryWrapperFilter(this.docQuery).bits(reader);
        return new BitSetExtSpans(reader, this, reader.maxDoc(), bits, this.inclusive);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Collection getTerms() {
        HashSet result = new HashSet();
        this.extractTerms(result);
        return result;
    }

    public void extractTerms(Set terms) {
        this.docQuery.extractTerms(terms);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("extSpanDoc(");
        buffer.append(this.inclusive);
        buffer.append(", {");
        buffer.append(this.docQuery.toString(field));
        buffer.append("})");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public ExtSpanQuery includedClause(int i) {
        return null;
    }

    public int numIncludedClauses() {
        return 0;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtSpanDocQuery)) {
            return false;
        }
        ExtSpanDocQuery other = (ExtSpanDocQuery)((Object)o);
        return this.inclusive == other.inclusive && this.docQuery.equals(other.docQuery) && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = this.docQuery.hashCode();
        h = h << 1 | h >>> 31;
        return h ^= this.inclusive ? -1716530243 : 0;
    }
}

