/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.BitSetExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.util.ToStringUtils;

public class ExtSpanDocBitSetQuery
extends ExtSpanQuery {
    private final BitSet acceptedDocs;
    private final boolean setBitIsAccepted;
    private String field;

    public ExtSpanDocBitSetQuery(BitSet acceptedDocs, boolean setBitIsAccepted) {
        this.acceptedDocs = acceptedDocs;
        this.setBitIsAccepted = setBitIsAccepted;
    }

    public ExtSpans getExtSpans(IndexReader reader) throws IOException {
        return new BitSetExtSpans(reader, this, reader.maxDoc(), this.acceptedDocs, this.setBitIsAccepted);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Collection getTerms() {
        return Collections.EMPTY_SET;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("extSpanDocBitSet(");
        buffer.append(this.setBitIsAccepted);
        buffer.append(", {");
        int bit = this.acceptedDocs.nextSetBit(0);
        if (bit >= 0) {
            buffer.append(bit);
            bit = this.acceptedDocs.nextSetBit(bit + 1);
            while (bit != -1) {
                buffer.append(", ").append(bit);
                bit = this.acceptedDocs.nextSetBit(bit + 1);
            }
        }
        buffer.append("})");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public ExtSpanQuery includedClause(int i) {
        return null;
    }

    public int numIncludedClauses() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtSpanDocBitSetQuery)) {
            return false;
        }
        ExtSpanDocBitSetQuery other = (ExtSpanDocBitSetQuery)((Object)o);
        return this.setBitIsAccepted == other.setBitIsAccepted && this.acceptedDocs.equals(other.acceptedDocs) && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = this.acceptedDocs.hashCode();
        h = h << 1 | h >>> 31;
        return h ^= this.setBitIsAccepted ? -1716530243 : 0;
    }

    public ExtSpanQuery optimize(boolean recurseToClauses) {
        return this;
    }
}

