/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpansFilter;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

public class DelegatedExtSpans
extends IterableExtSpans {
    private final ExtSpans extSpans;
    private final ExtSpanQuery originalQuery;
    private final ExtSpansFilter filter;
    private final ExtSpanQuery targetSubQuery;

    public DelegatedExtSpans(ExtSpans extSpans, ExtSpanQuery originalQuery) {
        this(extSpans, originalQuery, null);
    }

    public DelegatedExtSpans(ExtSpans extSpans, ExtSpanQuery originalQuery, ExtSpansFilter filter) {
        this(extSpans, originalQuery, filter, null);
    }

    public DelegatedExtSpans(ExtSpans extSpans, ExtSpanQuery originalQuery, ExtSpansFilter filter, ExtSpanQuery targetSubQuery) {
        super(extSpans.reader());
        this.extSpans = extSpans;
        this.originalQuery = originalQuery;
        this.filter = filter == null ? ExtSpansFilter.ACCEPT_ALL : filter;
        this.targetSubQuery = targetSubQuery;
    }

    private ExtSpans getTargetSpans() {
        if (this.targetSubQuery == null) {
            return this.extSpans;
        }
        for (int i = 0; i < this.extSpans.numSubExtSpans(); ++i) {
            if (this.extSpans.subExtSpan(i).query() != this.targetSubQuery) continue;
            return this.extSpans.subExtSpan(i);
        }
        return this.extSpans;
    }

    public int doc() {
        return this.getTargetSpans().doc();
    }

    public int end() {
        return this.getTargetSpans().end();
    }

    public boolean next() throws IOException {
        while (this.extSpans.next()) {
            if (!this.filter.accept(this.extSpans)) continue;
            return true;
        }
        return false;
    }

    public boolean skipTo(int arg0) throws IOException {
        if (!this.extSpans.skipTo(arg0)) {
            return false;
        }
        if (this.filter.accept(this.extSpans)) {
            return true;
        }
        return this.next();
    }

    public int start() {
        return this.getTargetSpans().start();
    }

    public int numSubExtSpans() {
        return 1;
    }

    public ExtSpans subExtSpan(int index) {
        return this.extSpans;
    }

    public ExtSpanQuery query() {
        return this.originalQuery;
    }
}

