/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans.extended;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.IterableExtSpans;

public class BitSetExtSpans
extends IterableExtSpans {
    private final ExtSpanQuery query;
    private final int maxDocNum;
    private final BitSet acceptedDocs;
    private final boolean setBitIsAccepted;
    private int doc = -1;

    public BitSetExtSpans(IndexReader reader, ExtSpanQuery query, int maxDocNum, BitSet acceptedDocs, boolean setBitIsAccepted) {
        super(reader);
        this.query = query;
        this.maxDocNum = maxDocNum;
        this.acceptedDocs = acceptedDocs;
        this.setBitIsAccepted = setBitIsAccepted;
    }

    public int numSubExtSpans() {
        return 0;
    }

    public ExtSpanQuery query() {
        return this.query;
    }

    public ExtSpans subExtSpan(int index) {
        return null;
    }

    public int doc() {
        return this.doc;
    }

    public int start() {
        return 0;
    }

    public int end() {
        return Integer.MAX_VALUE;
    }

    public boolean next() throws IOException {
        int nextDoc = this.setBitIsAccepted ? this.acceptedDocs.nextSetBit(this.doc + 1) : this.acceptedDocs.nextClearBit(this.doc + 1);
        if (nextDoc == -1 || nextDoc >= this.maxDocNum) {
            this.doc = this.maxDocNum;
            return false;
        }
        this.doc = nextDoc;
        return true;
    }

    public boolean skipTo(int doc) throws IOException {
        this.doc = Math.max(this.doc, doc - 1);
        return this.next();
    }
}

