/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.uima.index;

import com.ibm.supa.uima.index.NegationFsMatchConstraint;
import com.ibm.uima.cas.ConstraintFactory;
import com.ibm.uima.cas.FSConstraint;
import com.ibm.uima.cas.FSFloatConstraint;
import com.ibm.uima.cas.FSIntConstraint;
import com.ibm.uima.cas.FSMatchConstraint;
import com.ibm.uima.cas.FSStringConstraint;
import com.ibm.uima.search.Filter;
import com.ibm.uima.search.IndexingException;
import java.util.ArrayList;

public class FilterParser {
    private static final int STATE_START = 0;
    private static final int STATE_FEATURE = 1;
    private static final int STATE_BEFORE_OPERATOR = 2;
    private static final int STATE_OPERATOR = 3;
    private static final int STATE_AFTER_OPERATOR = 4;
    private static final int STATE_STRING = 5;
    private static final int STATE_NUM = 6;
    private static final int STATE_NUM_AFTER_POINT = 7;
    private static final int STATE_ESCAPE = 8;
    private static final int STATE_END = 9;
    private static final int OP_EQUAL = 0;
    private static final int OP_NOT_EQUAL = 1;
    private static final int OP_LESS = 2;
    private static final int OP_LESS_EQUAL = 3;
    private static final int OP_GREATER = 4;
    private static final int OP_GREATER_EQUAL = 5;

    public static FSMatchConstraint parse(Filter aFilter) throws IndexingException {
        FSStringConstraint c1;
        boolean negative;
        String featureName;
        block55: {
            Object literal;
            int operator;
            block54: {
                if (!aFilter.getSyntax().equals("FeatureValue")) {
                    throw new IndexingException("unsupported_filter_syntax", new Object[]{aFilter.getSyntax()});
                }
                featureName = null;
                String opStr = null;
                operator = -1;
                literal = null;
                String expr = aFilter.getExpression();
                int pos = 0;
                int state = 0;
                StringBuffer buf = new StringBuffer();
                while (pos < expr.length()) {
                    char c = expr.charAt(pos++);
                    switch (state) {
                        case 0: {
                            if (Character.isLetter(c) || c == '_') {
                                buf.append(c);
                                state = 1;
                                break;
                            }
                            if (Character.isWhitespace(c)) break;
                            throw new IndexingException("invalid_filter_feature_name", new Object[]{"" + c});
                        }
                        case 1: {
                            if (Character.isLetterOrDigit(c) || c == '_') {
                                buf.append(c);
                                break;
                            }
                            featureName = buf.toString();
                            buf.setLength(0);
                            --pos;
                            state = 2;
                            break;
                        }
                        case 2: {
                            if (Character.isWhitespace(c)) break;
                            buf.append(c);
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (c == '=' || c == '!' || c == '<' || c == '>') {
                                buf.append(c);
                                break;
                            }
                            opStr = buf.toString();
                            operator = FilterParser.getOp(opStr);
                            buf.setLength(0);
                            state = 4;
                            --pos;
                            break;
                        }
                        case 4: {
                            if (c == '\"') {
                                state = 5;
                                break;
                            }
                            if (Character.isDigit(c) || c == '-') {
                                state = 6;
                                buf.append(c);
                                break;
                            }
                            if (Character.isWhitespace(c)) break;
                            throw new IndexingException("invalid_filter_expected_literal", new Object[]{"" + c});
                        }
                        case 5: {
                            if (c == '\"') {
                                literal = buf.toString();
                                state = 9;
                                break;
                            }
                            if (c == '\\') {
                                state = 8;
                                break;
                            }
                            buf.append(c);
                            break;
                        }
                        case 8: {
                            if (c == '\"' || c == '\\') {
                                buf.append(c);
                                state = 5;
                                break;
                            }
                            throw new IndexingException("invalid_filter_escape", new Object[]{"\"\\" + c + "\""});
                        }
                        case 6: {
                            if (Character.isDigit(c)) {
                                buf.append(c);
                                break;
                            }
                            if (c == '.') {
                                buf.append(c);
                                state = 7;
                                break;
                            }
                            throw new IndexingException("invalid_filter_expected_digit_or_point", new Object[]{"" + c});
                        }
                        case 7: {
                            if (Character.isDigit(c)) {
                                buf.append(c);
                                break;
                            }
                            throw new IndexingException("invalid_filter_expected_digit", new Object[]{"" + c});
                        }
                        case 9: {
                            if (Character.isWhitespace(c)) break;
                            throw new IndexingException("invalid_filter_expected_end", new Object[]{"" + c});
                        }
                    }
                }
                if (state == 6) {
                    literal = new Integer(buf.toString());
                } else if (state == 7) {
                    literal = new Float(buf.toString());
                } else if (state != 9) {
                    throw new IndexingException("invalid_filter_unterminated_string", new Object[]{buf.toString()});
                }
                negative = false;
                c1 = null;
                if (!(literal instanceof String)) break block54;
                c1 = ConstraintFactory.instance().createStringConstraint();
                switch (operator) {
                    case 1: {
                        negative = true;
                    }
                    case 0: {
                        c1.equals((String)literal);
                        break block55;
                    }
                    default: {
                        throw new IndexingException("invalid_filter_string_operator", new Object[]{opStr});
                    }
                }
            }
            if (literal instanceof Integer) {
                int i = (Integer)literal;
                c1 = ConstraintFactory.instance().createIntConstraint();
                switch (operator) {
                    case 1: {
                        negative = true;
                    }
                    case 0: {
                        ((FSIntConstraint)c1).eq(i);
                        break;
                    }
                    case 2: {
                        ((FSIntConstraint)c1).lt(i);
                        break;
                    }
                    case 3: {
                        ((FSIntConstraint)c1).leq(i);
                        break;
                    }
                    case 4: {
                        ((FSIntConstraint)c1).gt(i);
                        break;
                    }
                    case 5: {
                        ((FSIntConstraint)c1).geq(i);
                    }
                }
            } else if (literal instanceof Float) {
                float f = ((Float)literal).floatValue();
                c1 = ConstraintFactory.instance().createFloatConstraint();
                switch (operator) {
                    case 1: {
                        negative = true;
                    }
                    case 0: {
                        ((FSFloatConstraint)c1).eq(f);
                        break;
                    }
                    case 2: {
                        ((FSFloatConstraint)c1).lt(f);
                        break;
                    }
                    case 3: {
                        ((FSFloatConstraint)c1).leq(f);
                        break;
                    }
                    case 4: {
                        ((FSFloatConstraint)c1).gt(f);
                        break;
                    }
                    case 5: {
                        ((FSFloatConstraint)c1).geq(f);
                    }
                }
            }
        }
        ArrayList<String> path = new ArrayList<String>();
        path.add(featureName);
        FSMatchConstraint c2 = ConstraintFactory.instance().embedConstraint(path, (FSConstraint)c1);
        if (!negative) {
            return c2;
        }
        return new NegationFsMatchConstraint(c2);
    }

    private static int getOp(String s) throws IndexingException {
        if (s.equals("=")) {
            return 0;
        }
        if (s.equals("!=")) {
            return 1;
        }
        if (s.equals("<")) {
            return 2;
        }
        if (s.equals("<=")) {
            return 3;
        }
        if (s.equals(">")) {
            return 4;
        }
        if (s.equals(">=")) {
            return 5;
        }
        throw new IndexingException("invalid_filter_expected_operator", new Object[]{s});
    }
}

