/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatingTokenizer
extends ChainedDelegateTokenizer {
    private boolean caseSensitive = false;
    private Map<String, String> translations;
    private boolean addOriginal = false;

    public void setAddOriginal(boolean append) {
        this.addOriginal = append;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setTranslations(Map<String, String> translations) {
        this.translations = translations;
    }

    public void init() {
        if (this.caseSensitive) {
            return;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entrySet = this.translations.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            newMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        this.translations = newMap;
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        String value;
        String tokenText = token.toString();
        if (!this.caseSensitive) {
            tokenText = tokenText.toLowerCase();
        }
        if ((value = this.translations.get(tokenText)) != null) {
            if (this.addOriginal) {
                accumulator.add(token);
            }
            accumulator.add(TTokenUtils.newToken((CharSequence)value, token.getType()));
        } else {
            accumulator.add(token);
        }
    }
}

