/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.supa.common.SUPAConstants;
import com.ibm.supa.common.SUPAUtils;

public abstract class TokenizationUtils {
    private static ThreadLocal<StringBuilder> builders = SUPAUtils.createThreadLocal(StringBuilder.class);

    public static boolean isLemma(String text) {
        return text.endsWith(SUPAConstants.LEMMA_MARKER_STRING) && !TokenizationUtils.isSubword(text) && !TokenizationUtils.isSubWordLemma(text);
    }

    public static boolean isSubword(String text) {
        return text.endsWith(SUPAConstants.SUBWORD_MARKER_STRING) || text.endsWith(SUPAConstants.INDEXED_SUBWORD_MARKER);
    }

    public static boolean isSubWordLemma(String text) {
        return text.endsWith(SUPAConstants.SUBWORDLEMMA_MARKER_STRING) || text.endsWith(SUPAConstants.INDEXED_SUBWORDLEMMA_MARKER);
    }

    public static boolean isSubwordForm(String text) {
        return TokenizationUtils.isSubword(text) || TokenizationUtils.isSubWordLemma(text);
    }

    public static String makeNonSubWordForm(String text) {
        return TokenizationUtils.trim(text, SUPAConstants.SUBWORD_MARKER_STRING, SUPAConstants.SUBWORDLEMMA_MARKER_STRING, SUPAConstants.INDEXED_SUBWORD_MARKER, SUPAConstants.INDEXED_SUBWORDLEMMA_MARKER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String concat(String a, String b) {
        StringBuilder sBuf = builders.get();
        try {
            String string = sBuf.append(a).append(b).toString();
            return string;
        }
        finally {
            sBuf.delete(0, sBuf.length());
        }
    }

    public static String makeIndexedSubWord(String text) {
        return TokenizationUtils.concat(text, SUPAConstants.INDEXED_SUBWORD_MARKER);
    }

    public static String makeIndexedSubWordLemma(String text) {
        return TokenizationUtils.concat(text, SUPAConstants.INDEXED_SUBWORDLEMMA_MARKER);
    }

    public static String makeIndexedLemma(String text) {
        return TokenizationUtils.concat(TokenizationUtils.makeNonLemma(text), SUPAConstants.INDEXED_LEMMA_MARKER);
    }

    public static String makeNonLemma(String text) {
        if (TokenizationUtils.isLemma(text)) {
            return TokenizationUtils.trim(text, SUPAConstants.LEMMA_MARKER_STRING);
        }
        return text;
    }

    public static String makeRegularForm(String text) {
        return TokenizationUtils.makeNonLemma(TokenizationUtils.makeNonSubWordForm(text));
    }

    private static String trim(String text, String ... suffices) {
        for (String suffix : suffices) {
            if (!text.endsWith(suffix)) continue;
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }
}

