/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TokenStreamTokenizer
extends ChainedDelegateTokenizer {
    protected TokenStream inStream = new TokenStream(){

        public Token next() throws IOException {
            return new Token(TokenStreamTokenizer.this.nextTokenText, 0, TokenStreamTokenizer.this.nextTokenText.length());
        }
    };
    protected String nextTokenText;
    protected TokenStream outStream;
    private boolean caseSensitive = false;
    private boolean addOriginal = false;
    private TToken.Type outType;

    public void setOutType(TToken.Type outType) {
        this.outType = outType;
    }

    public void setOutType(String outTypeName) {
        this.outType = TTokenUtils.requiredLookup(outTypeName);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setAddOriginal(boolean addOriginal) {
        this.addOriginal = addOriginal;
    }

    @Override
    protected void preChain(TokenizationParams params, List<TToken> accumulator) {
        super.preChain(params, accumulator);
        this.outStream = this.getOutStream(params, this.inStream);
    }

    protected abstract TokenStream getOutStream(TokenizationParams var1, TokenStream var2);

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        if (this.addOriginal) {
            accumulator.add(token);
        }
        this.nextTokenText = ((Object)TTokenUtils.getText(token, this.caseSensitive)).toString();
        try {
            Token out = this.outStream.next();
            if (out == null) {
                return;
            }
            String outText = out.termText();
            if (!this.caseSensitive) {
                outText = outText.toLowerCase();
            }
            if (!outText.equals(this.nextTokenText)) {
                accumulator.add(TTokenUtils.newToken((CharSequence)out.termText(), this.outType != null ? this.outType : token.getType()));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    protected void postChain(TokenizationParams params, List<TToken> accumulator) {
        this.outStream = null;
        super.postChain(params, accumulator);
    }
}

