/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenGathererTokenizer
extends ChainedDelegateTokenizer {
    private boolean caseSensitive = false;
    private ThreadLocal<LinkedHashMap<String, List<TToken>>> words = SUPAUtils.createThreadLocal(LinkedHashMap.class);

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    protected void preChain(TokenizationParams params, List<TToken> accumulator) {
        super.preChain(params, accumulator);
        this.words.get().clear();
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        String text = ((Object)TTokenUtils.getText(token, this.caseSensitive)).toString();
        LinkedHashMap<String, List<TToken>> wordMap = this.words.get();
        List<TToken> list = wordMap.get(text);
        if (list == null) {
            list = new LinkedList<TToken>();
            wordMap.put(text, list);
        }
        list.add(token);
    }

    @Override
    protected void postChain(TokenizationParams params, List<TToken> accumulator) {
        Collection<List<TToken>> valueSet = this.words.get().values();
        for (List<TToken> tokens : valueSet) {
            TToken both = null;
            TToken original = null;
            TToken lemma = null;
            TToken other = null;
            for (TToken token : tokens) {
                if (both == null && token.getType() == TToken.Type.BOTH) {
                    both = token;
                    continue;
                }
                if (original == null && token.getType() == TToken.Type.ORIGINAL) {
                    original = token;
                    continue;
                }
                if (lemma == null && token.getType() == TToken.Type.LEMMA) {
                    lemma = token;
                    continue;
                }
                if (other != null) continue;
                other = token;
            }
            if (both != null) {
                accumulator.add(TTokenUtils.newToken(both, TToken.Type.ORIGINAL));
                accumulator.add(TTokenUtils.newToken((CharSequence)both, TToken.Type.LEMMA));
                continue;
            }
            if (original != null) {
                accumulator.add(original);
                if (lemma == null) continue;
                accumulator.add(lemma);
                continue;
            }
            if (lemma != null) {
                accumulator.add(lemma);
                continue;
            }
            if (other == null) continue;
            accumulator.add(other);
        }
        this.words.get().clear();
        super.postChain(params, accumulator);
    }
}

