/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.common.SUPAConstants;
import com.ibm.supa.common.text.LowerCaseWrapper;
import com.ibm.supa.common.text.TextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTokenUtils {
    private static final Map<String, TToken.Type> typeLookup = new HashMap<String, TToken.Type>();

    private static void load(TToken.Type type, String ... names) {
        for (String name : names) {
            typeLookup.put(name.toLowerCase(), type);
        }
        typeLookup.put(type.toString().toLowerCase(), type);
    }

    public static List<TToken> caseReplace(List<TToken> tokens, CharSequence casedTokenText) {
        LinkedList<TToken> result = new LinkedList<TToken>();
        String casedString = ((Object)casedTokenText).toString();
        StringBuilder sBuf = new StringBuilder();
        for (TToken token : tokens) {
            CharSequence tokenText = TTokenUtils.getText(token, false);
            int matchLength = TextUtils.getMatchLength(tokenText, casedString, false);
            int start = sBuf.length();
            sBuf.append(casedString.substring(0, matchLength));
            sBuf.append(tokenText.subSequence(matchLength, tokenText.length()));
            int end = sBuf.length();
            result.add(TTokenUtils.newToken((CharSequence)sBuf, start, end, token.getType()));
        }
        return result;
    }

    public static CharSequence getText(TToken token, boolean caseSensitive) {
        CharSequence result = token;
        if (!caseSensitive) {
            result = new LowerCaseWrapper(result);
        }
        return result;
    }

    public static CharSequence getMarkedUpText(TToken token, boolean caseSensitive) {
        CharSequence result = TTokenUtils.getText(token, caseSensitive);
        if (token.getType() == TToken.Type.LEMMA) {
            result = result + SUPAConstants.LEMMA_MARKER_STRING;
        }
        return result;
    }

    public static TToken.Type lookup(String typeName) {
        return typeLookup.get(typeName.toLowerCase());
    }

    public static TToken newToken(CharSequence text, TToken.Type type) {
        return TTokenUtils.newToken(text, 0, text.length(), type);
    }

    public static TToken newToken(CharSequence text, int begin, int end, TToken.Type type) {
        return TToken.newToken(text, begin, end, type);
    }

    public static TToken newToken(CharSequence text, String typeName) {
        return TTokenUtils.newToken(text, 0, text.length(), typeName);
    }

    public static TToken newToken(CharSequence text, int begin, int end, String typeName) {
        return TToken.newToken(text, begin, end, TTokenUtils.requiredLookup(typeName));
    }

    public static TToken.Type requiredLookup(String typeName) throws RuntimeException {
        TToken.Type result = TTokenUtils.lookup(typeName);
        if (result == null) {
            throw new RuntimeException("No matching token type for: " + typeName);
        }
        return result;
    }

    public static <K> Map<K, TToken.Type> loadObjectToTypeMap(Map<K, String> map) {
        HashMap<K, TToken.Type> result = new HashMap<K, TToken.Type>();
        Set<Map.Entry<K, String>> entries = map.entrySet();
        for (Map.Entry<K, String> e : entries) {
            result.put(e.getKey(), TTokenUtils.requiredLookup(e.getValue()));
        }
        return result;
    }

    public static <V> Map<TToken.Type, V> loadTypeToObjectMap(Map<String, V> map) {
        HashMap<TToken.Type, V> result = new HashMap<TToken.Type, V>();
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> e : entries) {
            result.put(TTokenUtils.requiredLookup(e.getKey()), e.getValue());
        }
        return result;
    }

    public static Map<TToken.Type, TToken.Type> loadTypeToTypeMap(Map<String, String> map) {
        HashMap<TToken.Type, TToken.Type> result = new HashMap<TToken.Type, TToken.Type>();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> e : entries) {
            result.put(TTokenUtils.requiredLookup(e.getKey()), TTokenUtils.requiredLookup(e.getValue()));
        }
        return result;
    }

    public static Set<TToken.Type> loadTypeSet(Set<String> set) {
        HashSet<TToken.Type> result = new HashSet<TToken.Type>();
        for (String name : set) {
            result.add(TTokenUtils.requiredLookup(name));
        }
        return result;
    }

    static {
        TTokenUtils.load(TToken.Type.BOTH, "both");
        TTokenUtils.load(TToken.Type.LEMMA, "lemma");
        TTokenUtils.load(TToken.Type.NGRAM, "ngram");
        TTokenUtils.load(TToken.Type.ORIGINAL, "original");
        TTokenUtils.load(TToken.Type.PUNCTUATION, "punctuation", "punct", "punc");
        TTokenUtils.load(TToken.Type.WHITESPACE, "whitespace", "ws");
        TTokenUtils.load(TToken.Type.SENTENCE, "sentence");
        TTokenUtils.load(TToken.Type.GENERIC, "generic");
    }
}

