/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSplitTokenizer
extends ChainedDelegateTokenizer {
    private Set<String> delims;
    private boolean returnsDelims = false;
    private boolean insertSentenceBreaks = false;

    public void setDelims(Set<String> delims) {
        this.delims = delims;
    }

    public void setReturnsDelims(boolean returnsDelims) {
        this.returnsDelims = returnsDelims;
    }

    public void setInsertSentenceBreaks(boolean insertSentenceBreaks) {
        this.insertSentenceBreaks = insertSentenceBreaks;
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        TToken.Type type = token.getType();
        String tokenText = token.toString();
        int begin = 0;
        while (begin < tokenText.length()) {
            String firstDelim = null;
            int firstIndex = tokenText.length();
            for (String delim : this.delims) {
                int index = tokenText.indexOf(delim, begin);
                if (index < 0 || index >= firstIndex) continue;
                firstIndex = index;
                firstDelim = delim;
            }
            accumulator.add(TToken.newToken(token.subSequence(begin, firstIndex), type));
            begin = firstIndex;
            if (firstDelim == null) continue;
            if (this.returnsDelims) {
                accumulator.add(TToken.newToken(firstDelim, type));
            }
            if (this.insertSentenceBreaks) {
                accumulator.add(TToken.newSentenceBreak());
            }
            begin += firstDelim.length();
        }
    }
}

