/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexTypeMapperTokenizer
extends ChainedDelegateTokenizer {
    private Map<Pattern, TToken.Type> patternToTypeMap;

    public void setPatternToTypeMap(Map<String, String> map) {
        this.patternToTypeMap = new HashMap<Pattern, TToken.Type>();
        Map<String, TToken.Type> stringToTypeMap = TTokenUtils.loadObjectToTypeMap(map);
        Set<Map.Entry<String, TToken.Type>> entrySet = stringToTypeMap.entrySet();
        for (Map.Entry<String, TToken.Type> entry : entrySet) {
            this.patternToTypeMap.put(Pattern.compile(entry.getKey()), entry.getValue());
        }
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        Set<Map.Entry<Pattern, TToken.Type>> entrySet = this.patternToTypeMap.entrySet();
        for (Map.Entry<Pattern, TToken.Type> entry : entrySet) {
            if (!entry.getKey().matcher(token).matches()) continue;
            accumulator.add(TToken.newToken(token, entry.getValue()));
            return;
        }
        accumulator.add(token);
    }
}

