/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.TokenizerProcessInput;
import com.ibm.es.nuvo.tokenizer.XMLToken;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LemmatizationTokenizer
extends ChainedDelegateTokenizer
implements ResultHandler {
    private Tokenizer tokenizer;
    private List<TToken> accumulator;
    private Set<String> testedLanguages = new HashSet<String>();
    private Set<String> additionalLanguages;

    public void setAdditionalLanguages(Set<String> additionalLanguages) {
        this.additionalLanguages = additionalLanguages;
    }

    @Override
    protected void preChain(TokenizationParams params, List<TToken> accumulator) {
        super.preChain(params, accumulator);
        this.accumulator = accumulator;
        try {
            this.releaseTokenizer();
            this.tokenizer = GlobalSystem.getSingleInstance().getTokenizerPool().aquire(params.collectionId);
        }
        catch (TokenizerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        try {
            TokenizerProcessInput tpi = new TokenizerProcessInput(token, null, null);
            this.testedLanguages.clear();
            this.tokenize(token, tpi, null);
            this.tokenize(token, tpi, params.knownLanguage);
            this.tokenize(token, tpi, params.defaultLanguage);
            this.tokenize(token, tpi, params.detectedLanguage);
            for (String lang : this.additionalLanguages) {
                this.tokenize(token, tpi, lang);
            }
            this.testedLanguages.clear();
        }
        catch (TokenizerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void tokenize(TToken token, TokenizerProcessInput tpi, String language) throws TokenizerException {
        if (!this.testedLanguages.add(language)) {
            return;
        }
        tpi.setKnownLanguage(language);
        this.tokenizer.process(this, tpi);
    }

    @Override
    protected void postChain(TokenizationParams params, List<TToken> accumulator) {
        this.accumulator = null;
        this.releaseTokenizer();
        super.postChain(params, accumulator);
    }

    @Override
    public void releaseResources() {
        this.releaseTokenizer();
        super.releaseResources();
    }

    private void releaseTokenizer() {
        if (this.tokenizer != null) {
            GlobalSystem.getSingleInstance().getTokenizerPool().release(this.tokenizer);
            this.tokenizer = null;
        }
    }

    @Override
    public void addField(String name, String value) {
    }

    @Override
    public void addToken(TToken token, int begin, int end) {
        this.accumulator.add(token);
    }

    @Override
    public void addXMLToken(XMLToken xmlToken) {
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
    }
}

