/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstCopyTokenizer
extends ChainedDelegateTokenizer {
    private boolean caseSensitive = false;
    private ThreadLocal<Set<String>> words = SUPAUtils.createThreadLocal(HashSet.class);

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    protected void preChain(TokenizationParams params, List<TToken> accumulator) {
        super.preChain(params, accumulator);
        this.words.get().clear();
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        String text = ((Object)TTokenUtils.getText(token, this.caseSensitive)).toString();
        Set<String> wordsSeen = this.words.get();
        if (!wordsSeen.add(text)) {
            accumulator.add(token);
        }
    }

    @Override
    protected void postChain(TokenizationParams params, List<TToken> accumulator) {
        this.words.get().clear();
        super.postChain(params, accumulator);
    }
}

