/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryCache {
    private Map<String, SoftReference<Dictionary>> dictionaries = new ConcurrentHashMap<String, SoftReference<Dictionary>>();
    private int maxCachedDicts = Integer.MAX_VALUE;
    private Map<String, String> langToFileNamesMap;
    private AtomicBoolean removing = new AtomicBoolean(false);

    public void setMaxCachedDicts(int maxCachedDicts) {
        this.maxCachedDicts = maxCachedDicts;
    }

    public void setLangToFileNamesMap(Map<String, String> langToFileNamesMap) {
        this.langToFileNamesMap = langToFileNamesMap;
    }

    public Dictionary load(String lang) throws DLTException {
        Dictionary dict;
        if (lang == null || lang.length() < 2) {
            return null;
        }
        SoftReference<Dictionary> dictRef = this.dictionaries.get(lang = lang.toLowerCase().substring(0, 2));
        if (dictRef != null && (dict = dictRef.get()) != null) {
            return dict;
        }
        String fileName = this.langToFileNamesMap.get(lang);
        if (fileName == null) {
            return null;
        }
        String uimaData = GlobalConfiguration.getConfiguration().getUimaDataPath() + File.separator;
        Dictionary dict2 = new Dictionary(new File(uimaData, fileName));
        if (dict2 == null) {
            return null;
        }
        this.dictionaries.put(lang, new SoftReference<Dictionary>(dict2));
        if (this.dictionaries.size() > this.maxCachedDicts && this.removing.compareAndSet(false, true)) {
            Iterator<String> it = this.dictionaries.keySet().iterator();
            while (it.hasNext() && this.dictionaries.size() > this.maxCachedDicts) {
                it.remove();
            }
            this.removing.set(false);
        }
        return dict2;
    }
}

