/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.tokenizers.DelegateTokenizer;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedDelegateTokenizer
implements DelegateTokenizer {
    private DelegateTokenizer next;
    private int passThrough;

    public ChainedDelegateTokenizer() {
    }

    public ChainedDelegateTokenizer(DelegateTokenizer next) {
        this.next = next;
    }

    public void setNext(DelegateTokenizer next) {
        this.next = next;
    }

    public void setPassThrough(int passThrough) {
        this.passThrough = passThrough;
    }

    @Override
    public List<TToken> tokenize(TokenizationParams params, TToken token) {
        return this.tokenize(this.getNext(params, token), params, token);
    }

    protected DelegateTokenizer getNext(TokenizationParams params, TToken token) {
        return this.next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TToken> tokenize(DelegateTokenizer tokenizer, TokenizationParams params, TToken token) {
        LinkedList<TToken> result = new LinkedList<TToken>();
        try {
            this.preChain(params, result);
            if (tokenizer != null) {
                int tokenNumber;
                List<TToken> chainedResult = tokenizer.tokenize(params, token);
                Iterator<TToken> it = chainedResult.iterator();
                if (this.passThroughEnabled(params)) {
                    for (tokenNumber = 0; tokenNumber < this.passThrough && it.hasNext(); ++tokenNumber) {
                        result.add(it.next());
                    }
                }
                while (it.hasNext()) {
                    this.tokenize(params, it.next(), tokenNumber, result);
                    ++tokenNumber;
                }
            } else {
                this.tokenize(params, token, result);
            }
        }
        finally {
            this.postChain(params, result);
        }
        return result;
    }

    protected boolean passThroughEnabled(TokenizationParams params) {
        return true;
    }

    protected void preChain(TokenizationParams params, List<TToken> accumulator) {
    }

    protected void postChain(TokenizationParams params, List<TToken> accumulator) {
    }

    protected void tokenize(TokenizationParams params, TToken token, int tokenNumber, List<TToken> accumulator) {
        this.tokenize(params, token, accumulator);
    }

    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        accumulator.add(token);
    }

    @Override
    public void releaseResources() {
        if (this.next != null) {
            this.next.releaseResources();
        }
    }
}

