/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelCaseTokenizer
extends ChainedDelegateTokenizer {
    private boolean addOriginal = false;

    public void setAddOriginal(boolean addOriginal) {
        this.addOriginal = addOriginal;
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        if (this.addOriginal) {
            accumulator.add(token);
        }
        if (token.length() == 0) {
            return;
        }
        int start = 0;
        char ch = token.charAt(0);
        int numUpperChars = Character.isUpperCase(ch) ? 1 : 0;
        int numDigits = Character.isDigit(ch) ? 1 : 0;
        int numOthers = this.isOtherChar(ch) ? 1 : 0;
        for (int i = 1; i < token.length(); ++i) {
            ch = token.charAt(i);
            int currNumUpper = numUpperChars;
            int currNumDigits = numDigits;
            int currNumOthers = numOthers;
            numOthers = 0;
            numDigits = 0;
            numUpperChars = 0;
            if (Character.isUpperCase(ch)) {
                numUpperChars = currNumUpper;
                if (numUpperChars == 0) {
                    this.addToken(token, start, i, accumulator);
                    start = i;
                }
                ++numUpperChars;
                continue;
            }
            if (ch == '_') {
                this.addToken(token, start, i, accumulator);
                start = i + 1;
                continue;
            }
            if (Character.isDigit(ch)) {
                numDigits = currNumDigits;
                if (numDigits == 0) {
                    this.addToken(token, start, i, accumulator);
                    start = i;
                }
                ++numDigits;
                continue;
            }
            if (this.isOtherChar(ch)) {
                numOthers = currNumOthers;
                if (numOthers == 0) {
                    this.addToken(token, start, i, accumulator);
                    start = i;
                }
                ++numOthers;
                continue;
            }
            if (currNumUpper > 1) {
                this.addToken(token, start, i - 1, accumulator);
                start = i - 1;
                continue;
            }
            if (currNumDigits > 0) {
                this.addToken(token, start, i, accumulator);
                start = i;
                continue;
            }
            if (currNumOthers <= 0) continue;
            this.addToken(token, start, i, accumulator);
            start = i;
        }
        if (start != 0 && start < token.length()) {
            this.addToken(token, start, token.length(), accumulator);
        }
    }

    private boolean isOtherChar(char ch) {
        return ch != '_' && !Character.isLowerCase(ch) && !Character.isUpperCase(ch) && !Character.isDigit(ch);
    }

    private void addToken(TToken token, int begin, int end, List<TToken> accumulator) {
        if (end > begin) {
            accumulator.add(TToken.newToken(token, begin, end, TToken.Type.ORIGINAL));
        }
    }
}

