/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.tokenizers.DelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTokenizer
implements DelegateTokenizer {
    private static final int NUM_PROCS = Runtime.getRuntime().availableProcessors();
    private static final int MAX_ENTRIES_TO_REMOVE = Math.min(1024, 128 * NUM_PROCS);
    private static final double AVE_ENTRIES_TO_REMOVE = 64 * NUM_PROCS;
    private static final int OVERFLOW_BIAS = 10;
    private static final double EVICTION_PROB = 1.0 / (double)(10 * NUM_PROCS);
    private ConcurrentHashMap<String, List<TToken>> cache = new ConcurrentHashMap();
    private int maxCacheSize = 16384;
    private int biasSeed = 0;
    private AtomicBoolean removing = new AtomicBoolean(false);
    private boolean caseSensitive = true;
    private ThreadLocal<StringBuilder> builder = SUPAUtils.createThreadLocal(StringBuilder.class);
    private DelegateTokenizer next;

    public void setMaxCacheSize(int cacheSize) {
        this.maxCacheSize = cacheSize;
    }

    public void setNext(DelegateTokenizer next) {
        this.next = next;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public List<TToken> tokenize(TokenizationParams params, TToken token) {
        StringBuilder sBuf = this.builder.get();
        String key = sBuf.append(TTokenUtils.getText(token, this.caseSensitive)).append(token.getType()).toString();
        sBuf.delete(0, sBuf.length());
        List<TToken> result = this.cache.get(key);
        if (result != null) {
            return result;
        }
        result = this.next.tokenize(params, token);
        if (!this.caseSensitive) {
            result = TTokenUtils.caseReplace(result, token);
        }
        this.cache.put(key, result);
        int currCachOverflow = this.cache.size() - this.maxCacheSize;
        if (!this.removing.get() && currCachOverflow > 0) {
            this.removeEntries();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntries() {
        Random rng = new Random(System.currentTimeMillis() + Thread.currentThread().getId() + (long)this.biasSeed);
        ++this.biasSeed;
        if (rng.nextDouble() > EVICTION_PROB || !this.removing.compareAndSet(false, true)) {
            return;
        }
        CachingTokenizer cachingTokenizer = this;
        synchronized (cachingTokenizer) {
            if (this.cache.size() <= this.maxCacheSize) {
                return;
            }
            Iterator it = this.cache.keySet().iterator();
            int numRemoved = 0;
            double removeProb = AVE_ENTRIES_TO_REMOVE / (double)this.cache.size();
            while (it.hasNext() && numRemoved < MAX_ENTRIES_TO_REMOVE) {
                it.next();
                if (!(rng.nextDouble() < removeProb)) continue;
                it.remove();
            }
        }
        this.removing.set(false);
    }

    @Override
    public void releaseResources() {
        this.next.releaseResources();
    }
}

