/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.config.ConfigException;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.List;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.CodeBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSFTokenizer
extends ChainedDelegateTokenizer {
    private static final String PARAMS = "params";
    private static final String ACCUMULATOR = "accumulator";
    private static final String TOKEN = "token";
    private static final String TOKEN_NUMBER = "tokenNum";
    private BSFManager manager = new BSFManager();
    private String script;
    private BSFEngine engine;

    public void setScriptingLanguage(String language) {
        try {
            this.engine = this.manager.loadScriptingEngine(language);
        }
        catch (BSFException e) {
            throw new ConfigException(e);
        }
        this.compile();
    }

    public void setScript(String script) {
        this.script = script;
        this.compile();
    }

    private void compile() {
        if (this.engine != null && this.script != null) {
            try {
                this.engine.compileScript("param", 1, 1, (Object)this.script, new CodeBuffer());
            }
            catch (BSFException e) {
                throw new ConfigException("Compiling script failed: " + this.script, e);
            }
        }
    }

    @Override
    protected void preChain(TokenizationParams params, List<TToken> accumulator) {
        super.preChain(params, accumulator);
        this.manager.registerBean(PARAMS, (Object)params);
        this.manager.registerBean(ACCUMULATOR, accumulator);
    }

    @Override
    protected void postChain(TokenizationParams params, List<TToken> accumulator) {
        this.manager.unregisterBean(PARAMS);
        this.manager.unregisterBean(ACCUMULATOR);
        super.postChain(params, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tokenize(TokenizationParams params, TToken token, int tokenNumber, List<TToken> accumulator) {
        this.manager.registerBean(TOKEN, (Object)token);
        this.manager.registerBean(TOKEN_NUMBER, (Object)tokenNumber);
        try {
            this.engine.exec("run", 1, 1, (Object)this.script);
        }
        catch (BSFException e) {
            e.printStackTrace();
        }
        finally {
            this.manager.unregisterBean(TOKEN);
            this.manager.unregisterBean(TOKEN_NUMBER);
        }
    }
}

