/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.tokenizers;

import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.supa.common.SUPAUtils;
import com.ibm.supa.tokenizers.ChainedDelegateTokenizer;
import com.ibm.supa.tokenizers.TTokenUtils;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddXFixTokenizer
extends ChainedDelegateTokenizer {
    private Map<TToken.Type, String> typeToXfixMap;
    private boolean suffix;
    private ThreadLocal<StringBuilder> builder = SUPAUtils.createThreadLocal(StringBuilder.class);

    public void setTypeToSuffixMap(Map<String, String> typeToSuffixMap) {
        this.typeToXfixMap = TTokenUtils.loadTypeToObjectMap(typeToSuffixMap);
    }

    public void setSuffix(boolean suffix) {
        this.suffix = suffix;
    }

    @Override
    protected void tokenize(TokenizationParams params, TToken token, List<TToken> accumulator) {
        String xfix = this.typeToXfixMap.get(token.getType());
        if (xfix != null) {
            StringBuilder sBuf = this.builder.get();
            if (this.suffix) {
                sBuf.append(token).append(xfix);
            } else {
                sBuf.append(xfix).append(token);
            }
            accumulator.add(TToken.newToken(sBuf.toString(), token.getType()));
            sBuf.delete(0, sBuf.length());
        } else {
            accumulator.add(token);
        }
    }
}

