/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.security.simple;

import com.ibm.supa.security.AuthObjectLookup;
import com.ibm.supa.security.Permission;
import com.ibm.supa.security.simple.SimpleSecurityPolicy;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthObjectLookupImpl<P extends Permission>
implements AuthObjectLookup<SimpleSecurityPolicy, P> {
    private SimpleSecurityPolicy defaultPolicy;
    private Map<String, SimpleSecurityPolicy> permissionPolicies;

    public void setDefaultPolicy(SimpleSecurityPolicy policy) {
        this.defaultPolicy = policy;
    }

    public void setPermissionPolicies(Map<String, SimpleSecurityPolicy> permissionPolicies) {
        this.permissionPolicies = permissionPolicies;
    }

    @Override
    public SimpleSecurityPolicy getAuthObject(P permission) {
        SimpleSecurityPolicy result = null;
        if (this.permissionPolicies != null) {
            result = this.permissionPolicies.get(permission.name());
        }
        if (result == null) {
            result = this.defaultPolicy;
        }
        return result;
    }

    @Override
    public long getTimeout() {
        return 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdminAuthObjectLookupImpl
    extends AuthObjectLookupImpl<Permission.Admin>
    implements AuthObjectLookup.AdminAuthObjectLookup<SimpleSecurityPolicy> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserAuthObjectLookupImpl
    extends AuthObjectLookupImpl<Permission.User>
    implements AuthObjectLookup.UserAuthObjectLookup<SimpleSecurityPolicy> {
    }
}

