/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.summarizer.highlighter;

import com.ibm.es.nuvo.search.summarizer.highlighter.HTMLFormatter;
import com.ibm.supa.search.summarizer.highlighter.ExtendedSummaryFormatter;
import org.springframework.web.util.HtmlUtils;

public class ExtendedHTMLFormatter
extends HTMLFormatter
implements ExtendedSummaryFormatter {
    public static final String HIGHLIGHT_TERM_SPAN_CLASS_NAME = "supaHlTerm";
    public static final String HIGHLIGHT_GROUP_SPAN_CLASS_NAME = "supaHighlight";
    public static final String SECONDARY_HIGHLIGHT_TERM_SPAN_CLASS_NAME = "supaSecHlTerm";
    public static final String SECONDARY_HIGHLIGHT_GROUP_SPAN_CLASS_NAME = "supaSecHighlight";
    public static final String PRE_STYLE = "supaPre";
    private static final int NUM_LINE_NUMBER_DIGITS = 6;

    public void appendHighlightGroupPrefix(StringBuilder buffer) {
        buffer.append("<SPAN class=\"");
        buffer.append(HIGHLIGHT_GROUP_SPAN_CLASS_NAME);
        buffer.append("\">");
    }

    public void appendHighlightPrefix(StringBuilder buffer, int id) {
        buffer.append("<SPAN class=\"");
        buffer.append(HIGHLIGHT_TERM_SPAN_CLASS_NAME);
        buffer.append(id);
        buffer.append("\">");
    }

    public void appendSecondaryHighlightGroupPrefix(StringBuilder buffer) {
        buffer.append("<SPAN class=\"");
        buffer.append(SECONDARY_HIGHLIGHT_GROUP_SPAN_CLASS_NAME);
        buffer.append("\">");
    }

    public void appendSecondaryHighlightGroupPostfix(StringBuilder buffer) {
        buffer.append("</SPAN>");
    }

    public void appendSecondaryHighlightPrefix(StringBuilder buffer, int id) {
        buffer.append("<SPAN class=\"");
        buffer.append(SECONDARY_HIGHLIGHT_TERM_SPAN_CLASS_NAME);
        buffer.append(id);
        buffer.append("\">");
    }

    public void appendSecondaryHighlightPostfix(StringBuilder buffer, int id) {
        buffer.append("</SPAN>");
    }

    public void appendPreStylePrefix(StringBuilder buffer) {
        buffer.append("<SPAN class=\"");
        buffer.append(PRE_STYLE);
        buffer.append("\">");
    }

    public void appendPreStylePostfix(StringBuilder buffer) {
        buffer.append("</SPAN>");
    }

    public void appendLineStart(StringBuilder buffer, int lineNumber) {
        String lineNum = Integer.toString(lineNumber);
        buffer.append("L");
        int numDigitsToAdd = 6 - lineNum.length();
        for (int i = 0; i < numDigitsToAdd; ++i) {
            buffer.append("0");
        }
        buffer.append(lineNum);
        buffer.append("  ");
    }

    public void appendLineEnd(StringBuilder buffer, int lineNumber) {
    }

    public void appendText(StringBuilder buffer, CharSequence charSequence) {
        buffer.append(HtmlUtils.htmlEscape((String)((Object)charSequence).toString()));
    }
}

