/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended.tags;

import com.ibm.es.nuvo.markup.util.MarkupPayload;
import com.ibm.supa.search.spans.extended.tags.LeafTagExtSpans;
import com.ibm.supa.search.spans.extended.tags.TagExtSpans;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;
import org.apache.lucene.search.spans.extended.TermExtSpans;

public class TermTagExtSpans
extends TermExtSpans
implements TagExtSpans {
    private int payloadId = -1;
    private int payloadEnd = -1;
    private int payloadIdLast = -1;
    private int payloadDepth = -1;
    private MarkupPayload markupPayload = new MarkupPayload();
    private boolean payloadFieldsNeedUpdating = false;

    public TermTagExtSpans(ExtSpanQuery query, IndexReader reader, Term term) throws IOException {
        super(query, reader, term);
    }

    public ExtSpans nonIterableCopy(boolean deepCopy) {
        return new LeafTagExtSpans(this);
    }

    public boolean next() throws IOException {
        if (super.next()) {
            this.payloadFieldsNeedUpdating = true;
            return true;
        }
        return false;
    }

    public boolean skipTo(int target) throws IOException {
        if (super.skipTo(target)) {
            this.payloadFieldsNeedUpdating = true;
            return true;
        }
        return false;
    }

    public int end() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadEnd;
    }

    public int id() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadId;
    }

    public int idLast() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadIdLast;
    }

    public int depth() {
        if (this.payloadFieldsNeedUpdating) {
            this.updatePayloadFields();
        }
        return this.payloadDepth;
    }

    public String toString() {
        return "tagSpans(" + this.term.toString() + ")@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : this.doc + "(" + this.start() + "," + this.end() + ")[" + this.id() + "," + this.idLast() + "]" + this.depth()));
    }

    private void updatePayloadFields() {
        try {
            this.markupPayload.loadFromTermPositions(this.positions);
            this.payloadId = this.markupPayload.getTagSerialNumber();
            this.payloadEnd = this.position + this.markupPayload.getNumberOfTokensSpanned();
            this.payloadIdLast = this.payloadId + this.markupPayload.getNumberOfDescendants();
            this.payloadDepth = this.markupPayload.getTagDepth();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.payloadId = -1;
            this.payloadEnd = -1;
            this.payloadIdLast = -1;
            this.payloadDepth = -1;
            throw new RuntimeException(e);
        }
        finally {
            this.payloadFieldsNeedUpdating = false;
        }
    }
}

