/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.search.spans.extended.tags;

import com.ibm.supa.search.spans.extended.ExtSpanUtils;
import com.ibm.supa.search.spans.extended.tags.LeafTagExtSpans;
import com.ibm.supa.search.spans.extended.tags.SingleTagExtSpans;
import com.ibm.supa.search.spans.extended.tags.TagExtSpans;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.extended.BaseExtSpans;
import org.apache.lucene.search.spans.extended.ExtSpanQuery;
import org.apache.lucene.search.spans.extended.ExtSpans;

public class SimpleSameIDExtSpans
extends BaseExtSpans
implements TagExtSpans {
    public static final ExtSpanUtils.Aligner<TagExtSpans> IDAligner = new ExtSpanUtils.Aligner<TagExtSpans>(){

        @Override
        public boolean advance(TagExtSpans from, TagExtSpans to) throws IOException {
            if (!from.skipTo(to.doc())) {
                return false;
            }
            while (this.lessThan(from, to)) {
                if (from.next()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean lessThan(TagExtSpans o1, TagExtSpans o2) {
            return o1.doc() < o2.doc() || o1.doc() == o2.doc() && o1.id() < o2.id();
        }
    };
    private TagExtSpans[] extSpans;
    private ExtSpanQuery query;
    private boolean more;
    private LinkedList<TagExtSpans> workList;

    public SimpleSameIDExtSpans(ExtSpanQuery query, ExtSpanQuery[] clauses, IndexReader reader) throws IOException {
        super(reader);
        this.query = query;
        this.more = true;
        this.extSpans = new TagExtSpans[clauses.length];
        for (int i = 0; i < clauses.length && this.more; ++i) {
            this.extSpans[i] = (TagExtSpans)clauses[i].getExtSpans(reader);
            if (i <= 0) continue;
            this.more = this.extSpans[i].next();
        }
        this.workList = new LinkedList();
    }

    private boolean align() throws IOException {
        return ExtSpanUtils.align(IDAligner, this.workList, (int)0, (ExtSpans[])this.extSpans);
    }

    public ExtSpans nonIterableCopy(boolean deepCopy) {
        if (deepCopy) {
            return new SingleTagExtSpans(this);
        }
        return new LeafTagExtSpans(this);
    }

    public boolean next() throws IOException {
        if (this.more) {
            this.more = this.extSpans[0].next() && this.align();
        }
        return this.more;
    }

    public boolean skipTo(int doc) throws IOException {
        if (this.more) {
            this.more = this.extSpans[0].skipTo(doc) && this.align();
        }
        return this.more;
    }

    public int start() {
        return this.extSpans[0].start();
    }

    public int end() {
        return this.extSpans[0].end();
    }

    public int doc() {
        return this.extSpans[0].doc();
    }

    public int id() {
        return this.extSpans[0].id();
    }

    public int idLast() {
        return this.extSpans[0].idLast();
    }

    public int depth() {
        return this.extSpans[0].depth();
    }

    public int numSubExtSpans() {
        return this.extSpans.length;
    }

    public ExtSpans subExtSpan(int index) {
        return this.extSpans[index];
    }

    public ExtSpanQuery query() {
        return this.query;
    }
}

